/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;
import pigcart.particlerain.particle.CustomParticle;
import pigcart.particlerain.particle.StreakParticle;

public final class WeatherParticleManager {
    private static final RandomSource random = RandomSource.m_216327_();
    public static ParticleGroup particleGroup = new ParticleGroup(ConfigManager.config.perf.maxParticleAmount);
    private static final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private static final BlockPos.MutableBlockPos heightmapPos = new BlockPos.MutableBlockPos();
    public static int afterWeatherTicksLeft = 0;
    public static int spawnAttemptsUntilBlockFXIdle = 0;
    public static int ticksUntilSurfaceFXIdle = 0;
    public static int ticksUntilSkyFXIdle = 0;

    public static int getParticleCount() {
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)Minecraft.m_91087_().f_91061_;
        return particleEngine.getTrackedParticleCounts().getInt((Object)particleGroup);
    }

    public static void tick(ClientLevel level, Vec3 cameraPos) {
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)Minecraft.m_91087_().f_91061_;
        if (!particleEngine.callHasSpaceInParticleLimit(particleGroup)) {
            return;
        }
        WeatherParticleManager.tickSkyFX(level, cameraPos);
        WeatherParticleManager.tickSurfaceFX(level, cameraPos);
        if (afterWeatherTicksLeft > 0) {
            --afterWeatherTicksLeft;
        }
    }

    public static void onWeatherChange(boolean isRaining) {
        afterWeatherTicksLeft = isRaining ? 0 : random.m_188503_(6000);
    }

    public static void tickBlockFX(BlockPos.MutableBlockPos sourcePos, BlockState state) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (spawnAttemptsUntilBlockFXIdle <= 0 && random.m_188501_() < 0.9f) {
            return;
        }
        --spawnAttemptsUntilBlockFXIdle;
        if (!state.m_60812_((BlockGetter)level, (BlockPos)sourcePos).m_83281_()) {
            return;
        }
        for (ConfigData.ParticleData opts : ConfigManager.config.particles) {
            Vector3f relativePos;
            Direction direction;
            if (!opts.enabled || !opts.weather.isCurrent(level)) continue;
            Holder biome = level.m_204166_((BlockPos)sourcePos);
            switch (opts.spawnPos) {
                case BLOCK_SIDES: {
                    Direction direction2 = Direction.Plane.HORIZONTAL.m_235690_(random);
                    break;
                }
                case BLOCK_BOTTOM: {
                    Direction direction2 = Direction.DOWN;
                    break;
                }
                case BLOCK_TOP: {
                    Direction direction2 = Direction.UP;
                    break;
                }
                default: {
                    Direction direction2 = direction = null;
                }
            }
            if (direction == null) continue;
            Direction opposite = direction.m_122424_();
            pos.m_122178_(sourcePos.m_123341_() + opposite.m_122429_(), sourcePos.m_123342_() + opposite.m_122430_(), sourcePos.m_123343_() + opposite.m_122431_());
            BlockState blockState = level.m_8055_((BlockPos)pos);
            FluidState fluidState = blockState.m_60819_();
            if (blockState.m_60812_((BlockGetter)level, (BlockPos)pos).m_83281_() && fluidState.m_76178_() || opts.spawnPos != ConfigData.SpawnPos.BLOCK_BOTTOM && opts.spawnPos != ConfigData.SpawnPos.BLOCK_SIDES && opts.spawnPos != ConfigData.SpawnPos.BLOCK_TOP || !opts.precipitation.contains(VersionUtil.getPrecipitationAt((Level)level, (Holder<Biome>)biome, (BlockPos)sourcePos)) || !(opts.density > random.m_188501_()) || !opts.biomeList.contains(biome) || !opts.blockList.contains(level.m_8055_((BlockPos)pos).m_222976_()) || opts.needsSkyAccess && sourcePos.m_123342_() < level.m_6924_(Heightmap.Types.MOTION_BLOCKING, sourcePos.m_123341_(), sourcePos.m_123343_())) continue;
            float p1 = random.m_188501_();
            float p2 = random.m_188501_();
            if (direction.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE)) {
                double max = blockState.m_60812_((BlockGetter)level, (BlockPos)pos).m_83290_(direction.m_122434_(), (double)p1, (double)p2);
                if (direction == Direction.UP) {
                    max = Math.max(max, (double)fluidState.m_76155_((BlockGetter)level, (BlockPos)pos));
                }
                if (max == Double.NEGATIVE_INFINITY) continue;
                relativePos = new Vector3f(p2 - 0.5f, (float)(max += 0.01) - 0.5f, p1 - 0.5f);
            } else {
                double min = blockState.m_60812_((BlockGetter)level, (BlockPos)pos).m_166078_(direction.m_122434_(), (double)p1, (double)p2);
                if (min == Double.POSITIVE_INFINITY) continue;
                relativePos = new Vector3f(p2 - 0.5f, (float)(min -= 0.01) - 0.5f, p1 - 0.5f);
            }
            relativePos.rotate((Quaternionfc)(switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP, Direction.DOWN -> new Quaternionf();
                case Direction.SOUTH, Direction.NORTH -> new Quaternionf().rotationXYZ(1.5707964f, 1.5707964f, 0.0f);
                case Direction.EAST, Direction.WEST -> new Quaternionf().rotationXYZ(-1.5707964f, 0.0f, -1.5707964f);
            }));
            float x = (float)pos.m_123341_() + relativePos.x + 0.5f;
            float y = (float)pos.m_123342_() + relativePos.y + 0.5f;
            float z = (float)pos.m_123343_() + relativePos.z + 0.5f;
            if (opts.usePresetParticle) {
                if (opts.presetParticleId.equals("particlerain:streak")) {
                    Minecraft.m_91087_().f_91061_.m_107344_((Particle)new StreakParticle(level, x, y, z, direction, opts.blockList));
                } else {
                    level.m_7106_(opts.presetParticle, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                }
            } else {
                Minecraft.m_91087_().f_91061_.m_107344_((Particle)new CustomParticle(level, (double)x, (double)y, (double)z, opts));
            }
            spawnAttemptsUntilBlockFXIdle = 10000;
        }
    }

    public static void tickSkyFX(ClientLevel level, Vec3 cameraPos) {
        float speed;
        int density;
        if (ticksUntilSkyFXIdle <= 0) {
            density = 4;
            speed = 0.0f;
        } else {
            --ticksUntilSkyFXIdle;
            density = (int)((float)Mth.m_269140_((float)level.m_46661_(1.0f), (int)ConfigManager.config.perf.particleDensity, (int)ConfigManager.config.perf.particleStormDensity) * level.m_46722_(1.0f));
            speed = (float)Minecraft.m_91087_().m_91288_().m_20184_().m_82553_();
            density = (int)((float)density * (1.0f + speed));
        }
        for (int i = 0; i < density; ++i) {
            float height;
            if ((double)speed < 0.8) {
                height = Mth.m_14154_((float)(Mth.m_14207_((float)random.m_188501_()) - Mth.m_14207_((float)random.m_188501_()))) * -1.0f + 1.0f;
                height *= 1.0f;
            } else {
                height = random.m_188501_();
            }
            float theta = (float)Math.PI * 2 * random.m_188501_();
            float phi = (float)Math.acos(2.0f * height - 1.0f);
            float x = (float)ConfigManager.config.perf.particleDistance * Mth.m_14031_((float)phi) * Mth.m_14089_((float)theta) + (float)cameraPos.f_82479_;
            float y = (float)ConfigManager.config.perf.particleDistance * Mth.m_14089_((float)phi) + (float)cameraPos.f_82480_;
            float z = (float)ConfigManager.config.perf.particleDistance * Mth.m_14031_((float)phi) * Mth.m_14031_((float)theta) + (float)cameraPos.f_82481_;
            if (ConfigManager.config.compat.doSpawnHeightLimit) {
                int cloudHeight;
                int n = cloudHeight = ConfigManager.config.compat.spawnHeightLimit == 0 ? VersionUtil.getCloudHeight(level) : ConfigManager.config.compat.spawnHeightLimit;
                if (cloudHeight != 0 && y > (float)cloudHeight) {
                    y = cloudHeight;
                }
            }
            pos.m_122169_((double)x, (double)y, (double)z);
            int heightmapY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
            heightmapPos.m_122169_((double)x, (double)(heightmapY - 1), (double)z);
            if (heightmapY > pos.m_123342_()) continue;
            Holder biome = level.m_204166_((BlockPos)pos);
            Biome.Precipitation precipitation = VersionUtil.getPrecipitationAt((Level)level, (Holder<Biome>)biome, (BlockPos)(ConfigManager.config.compat.useHeightmapTemp ? heightmapPos : pos));
            for (ConfigData.ParticleData data : ConfigManager.config.particles) {
                if (!data.enabled || !data.spawnPos.equals((Object)ConfigData.SpawnPos.SKY) || !data.weather.isCurrent(level) || !data.precipitation.contains(precipitation) || !(data.density > random.m_188501_()) || !data.biomeList.contains(biome) || !data.blockList.contains(level.m_8055_((BlockPos)heightmapPos).m_222976_())) continue;
                if (data.usePresetParticle) {
                    level.m_7106_(data.presetParticle, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                } else {
                    Minecraft.m_91087_().f_91061_.m_107344_((Particle)new CustomParticle(level, (double)x, (double)y, (double)z, data));
                }
                ticksUntilSkyFXIdle = 100;
            }
        }
    }

    public static void tickSurfaceFX(ClientLevel level, Vec3 cameraPos) {
        int density;
        if (ticksUntilSurfaceFXIdle <= 0) {
            density = 1;
        } else {
            density = ConfigManager.config.perf.particleDensity;
            --ticksUntilSurfaceFXIdle;
        }
        for (int i = 0; i < density; ++i) {
            double x = random.m_216328_(cameraPos.f_82479_, (double)ConfigManager.config.perf.surfaceRange);
            double z = random.m_216328_(cameraPos.f_82481_, (double)ConfigManager.config.perf.surfaceRange);
            int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z);
            pos.m_122169_(x, (double)(y - 1), z);
            BlockState blockState = level.m_8055_((BlockPos)pos);
            Holder biome = level.m_204166_((BlockPos)pos);
            Biome.Precipitation precipitation = VersionUtil.getPrecipitationAt((Level)level, (Holder<Biome>)biome, (BlockPos)pos);
            for (ConfigData.ParticleData data : ConfigManager.config.particles) {
                if (!data.enabled || !data.spawnPos.equals((Object)ConfigData.SpawnPos.WORLD_SURFACE) || !data.weather.isCurrent(level) || !data.precipitation.contains(precipitation) || !(data.density > random.m_188501_()) || !data.biomeList.contains(biome) || !data.blockList.contains(blockState.m_222976_())) continue;
                if (data.usePresetParticle) {
                    level.m_7106_(data.presetParticle, x, (double)y, z, 0.0, 0.0, 0.0);
                } else {
                    Minecraft.m_91087_().f_91061_.m_107344_((Particle)new CustomParticle(level, x, (double)y, z, data));
                }
                ticksUntilSurfaceFXIdle = 100;
            }
        }
    }
}

