/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.virtualWorld;

import com.simibubi.create.foundation.virtualWorld.VirtualChunkSource;
import com.simibubi.create.foundation.virtualWorld.VirtualLevelEntityGetter;
import dev.engine_room.flywheel.api.visualization.VisualizationLevel;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;

public class VirtualRenderWorld
extends Level
implements VisualizationLevel {
    protected final Level level;
    protected final int minBuildHeight;
    protected final int height;
    protected final Vec3i biomeOffset;
    protected final VirtualChunkSource chunkSource;
    protected final LevelLightEngine lightEngine;
    protected final Map<BlockPos, BlockState> blockStates = new HashMap<BlockPos, BlockState>();
    protected final Map<BlockPos, BlockEntity> blockEntities = new HashMap<BlockPos, BlockEntity>();
    protected final Object2ShortMap<SectionPos> nonEmptyBlockCounts = new Object2ShortOpenHashMap();
    protected final LevelEntityGetter<Entity> entityGetter = new VirtualLevelEntityGetter<Entity>();
    protected final BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
    protected final Runnable onBlockUpdated;
    private int externalPackedLight = 0;

    public VirtualRenderWorld(Level level, int minBuildHeight, int height, Vec3i biomeOffset, Runnable onBlockUpdated) {
        super((WritableLevelData)level.m_6106_(), level.m_46472_(), level.m_9598_(), level.m_204156_(), level.m_46658_(), true, false, 0L, 0);
        this.level = level;
        this.minBuildHeight = VirtualRenderWorld.nextMultipleOf16(minBuildHeight);
        this.height = VirtualRenderWorld.nextMultipleOf16(height);
        this.biomeOffset = biomeOffset;
        this.chunkSource = new VirtualChunkSource(this);
        this.lightEngine = new LevelLightEngine((LightChunkGetter)this.chunkSource, true, false);
        this.onBlockUpdated = onBlockUpdated;
    }

    public static int nextMultipleOf16(int a) {
        if (a < 0) {
            return -((Math.abs(a) - 1 | 0xF) + 1);
        }
        return (a - 1 | 0xF) + 1;
    }

    public void setExternalLight(int packedLight) {
        this.externalPackedLight = packedLight;
    }

    public void resetExternalLight() {
        this.externalPackedLight = 0;
    }

    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        this.onBlockUpdated.run();
    }

    public int m_45517_(LightLayer lightType, BlockPos blockPos) {
        int selfBrightness = super.m_45517_(lightType, blockPos);
        if (lightType == LightLayer.SKY) {
            return Math.max(selfBrightness, LightTexture.m_109894_((int)this.externalPackedLight));
        }
        return Math.max(selfBrightness, LightTexture.m_109883_((int)this.externalPackedLight));
    }

    public void clear() {
        this.blockStates.clear();
        this.blockEntities.clear();
        this.nonEmptyBlockCounts.forEach((sectionPos, nonEmptyBlockCount) -> {
            if (nonEmptyBlockCount > 0) {
                this.lightEngine.m_6191_(sectionPos, true);
            }
        });
        this.nonEmptyBlockCounts.clear();
    }

    public void setBlockEntities(Collection<BlockEntity> blockEntities) {
        this.blockEntities.clear();
        blockEntities.forEach(this::m_151523_);
    }

    public void runLightEngine() {
        ObjectOpenHashSet chunkPosSet = new ObjectOpenHashSet();
        this.nonEmptyBlockCounts.object2ShortEntrySet().forEach(arg_0 -> VirtualRenderWorld.lambda$runLightEngine$1((Set)chunkPosSet, arg_0));
        for (ChunkPos chunkPos : chunkPosSet) {
            this.lightEngine.m_142519_(chunkPos);
        }
        this.lightEngine.m_9323_();
    }

    public LevelChunk m_6325_(int x, int z) {
        throw new UnsupportedOperationException();
    }

    public ChunkAccess actuallyGetChunk(int x, int z) {
        return this.m_46819_(x, z, ChunkStatus.f_62326_);
    }

    public ChunkAccess m_46865_(BlockPos pos) {
        return this.actuallyGetChunk(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
    }

    public boolean m_6933_(BlockPos pos, BlockState newState, int flags, int recursionLeft) {
        boolean nowEmpty;
        boolean prevEmpty;
        if (this.m_151570_(pos)) {
            return false;
        }
        BlockState oldState = this.m_8055_(pos = pos.m_7949_());
        if (oldState == newState) {
            return false;
        }
        this.blockStates.put(pos, newState);
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)pos);
        short nonEmptyBlockCount = this.nonEmptyBlockCounts.getShort((Object)sectionPos);
        boolean bl = prevEmpty = nonEmptyBlockCount == 0;
        if (!oldState.m_60795_()) {
            nonEmptyBlockCount = (short)(nonEmptyBlockCount - 1);
        }
        if (!newState.m_60795_()) {
            nonEmptyBlockCount = (short)(nonEmptyBlockCount + 1);
        }
        this.nonEmptyBlockCounts.put((Object)sectionPos, nonEmptyBlockCount);
        boolean bl2 = nowEmpty = nonEmptyBlockCount == 0;
        if (prevEmpty != nowEmpty) {
            this.lightEngine.m_6191_(sectionPos, nowEmpty);
        }
        this.lightEngine.m_7174_(pos);
        return true;
    }

    public LevelLightEngine m_5518_() {
        return this.lightEngine;
    }

    public BlockState m_8055_(BlockPos pos) {
        if (this.m_151570_(pos)) {
            return Blocks.f_50626_.m_49966_();
        }
        BlockState state = this.blockStates.get(pos);
        if (state != null) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.m_8055_((BlockPos)this.scratchPos.m_122178_(x, y, z));
    }

    public FluidState m_6425_(BlockPos pos) {
        if (this.m_151570_(pos)) {
            return Fluids.f_76191_.m_76145_();
        }
        return this.m_8055_(pos).m_60819_();
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        if (!this.m_151570_(pos)) {
            return this.blockEntities.get(pos);
        }
        return null;
    }

    public void m_151523_(BlockEntity blockEntity) {
        BlockPos pos = blockEntity.m_58899_();
        if (!this.m_151570_(pos)) {
            this.blockEntities.put(pos, blockEntity);
        }
    }

    public void m_46747_(BlockPos pos) {
        if (!this.m_151570_(pos)) {
            this.blockEntities.remove(pos);
        }
    }

    protected LevelEntityGetter<Entity> m_142646_() {
        return this.entityGetter;
    }

    public ChunkSource m_7726_() {
        return this.chunkSource;
    }

    public int m_141937_() {
        return this.minBuildHeight;
    }

    public int m_141928_() {
        return this.height;
    }

    public Holder<Biome> m_204166_(BlockPos pos) {
        return super.m_204166_(pos.m_121955_(this.biomeOffset));
    }

    public Holder<Biome> m_203495_(int x, int y, int z) {
        return this.level.m_203495_(x + this.biomeOffset.m_123341_(), y + this.biomeOffset.m_123342_(), z + this.biomeOffset.m_123343_());
    }

    public Holder<Biome> m_203675_(int x, int y, int z) {
        return this.level.m_203675_(x + this.biomeOffset.m_123341_(), y + this.biomeOffset.m_123342_(), z + this.biomeOffset.m_123343_());
    }

    public int m_46803_(BlockPos pos) {
        return 15;
    }

    public float m_7717_(Direction direction, boolean shade) {
        return 1.0f;
    }

    public Scoreboard m_6188_() {
        return this.level.m_6188_();
    }

    public RecipeManager m_7465_() {
        return this.level.m_7465_();
    }

    public BiomeManager m_7062_() {
        return this.level.m_7062_();
    }

    public LevelTickAccess<Block> m_183326_() {
        return this.level.m_183326_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return this.level.m_183324_();
    }

    public FeatureFlagSet m_246046_() {
        return this.level.m_246046_();
    }

    public void m_46717_(BlockPos pos, Block block) {
    }

    public boolean m_46749_(BlockPos pos) {
        return true;
    }

    public boolean isAreaLoaded(BlockPos center, int range) {
        return true;
    }

    public void m_262808_(Player player, double x, double y, double z, Holder<SoundEvent> soundEvent, SoundSource soundSource, float volume, float pitch, long seed) {
    }

    public void m_213890_(Player player, Entity entity, Holder<SoundEvent> soundEvent, SoundSource soundSource, float volume, float pitch, long seed) {
    }

    public String m_46464_() {
        return "";
    }

    @Nullable
    public Entity m_6815_(int id) {
        return null;
    }

    @Nullable
    public MapItemSavedData m_7489_(String mapName) {
        return null;
    }

    public void m_142325_(String mapId, MapItemSavedData data) {
    }

    public int m_7354_() {
        return 0;
    }

    public void m_6801_(int breakerId, BlockPos pos, int progress) {
    }

    public void m_5898_(@Nullable Player player, int type, BlockPos pos, int data) {
    }

    public void m_214171_(GameEvent event, Vec3 position, GameEvent.Context context) {
    }

    public List<? extends Player> m_6907_() {
        return Collections.emptyList();
    }

    public LevelChunk getChunkAtImmediately(int chunkX, int chunkZ) {
        return this.chunkSource.m_62227_(chunkX, chunkZ, false);
    }

    public ChunkAccess getAnyChunkImmediately(int chunkX, int chunkZ) {
        return this.chunkSource.getChunk(chunkX, chunkZ);
    }

    public int m_151558_() {
        return this.m_141937_() + this.m_141928_();
    }

    public int m_151559_() {
        return this.m_151561_() - this.m_151560_();
    }

    public int m_151560_() {
        return SectionPos.m_123171_((int)this.m_141937_());
    }

    public int m_151561_() {
        return SectionPos.m_123171_((int)(this.m_151558_() - 1)) + 1;
    }

    public boolean m_151570_(BlockPos pos) {
        return this.m_151562_(pos.m_123342_());
    }

    public boolean m_151562_(int y) {
        return y < this.m_141937_() || y >= this.m_151558_();
    }

    public int m_151564_(int y) {
        return this.m_151566_(SectionPos.m_123171_((int)y));
    }

    public int m_151566_(int sectionY) {
        return sectionY - this.m_151560_();
    }

    public int m_151568_(int sectionIndex) {
        return sectionIndex + this.m_151560_();
    }

    private static /* synthetic */ void lambda$runLightEngine$1(Set chunkPosSet, Object2ShortMap.Entry entry) {
        if (entry.getShortValue() > 0) {
            chunkPosSet.add(((SectionPos)entry.getKey()).m_123251_());
        }
    }
}

