/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnEntityStartsBeingInSightListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnEntityStopsBeingInSightListener
extends AbstractListener {
    @Nullable
    private OnEntityStartsBeingInSightListener.EntitySightData lastEntityData;

    public OnEntityStopsBeingInSightListener() {
        super("entity_stops_being_in_sight");
    }

    public void onEntityStopped(@Nullable OnEntityStartsBeingInSightListener.EntitySightData data) {
        this.lastEntityData = data;
        if (data != null) {
            this.notifyAllInstances();
        }
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("entity_key", () -> {
            OnEntityStartsBeingInSightListener.EntitySightData data = this.lastEntityData;
            if (data == null || data.entityKey() == null) {
                return "ERROR";
            }
            return data.entityKey();
        }));
        list.add(new AbstractListener.CustomVariable("distance_to_player", () -> {
            OnEntityStartsBeingInSightListener.EntitySightData data = this.lastEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.distanceToPlayer());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_x", () -> {
            OnEntityStartsBeingInSightListener.EntitySightData data = this.lastEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosX());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_y", () -> {
            OnEntityStartsBeingInSightListener.EntitySightData data = this.lastEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosY());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_z", () -> {
            OnEntityStartsBeingInSightListener.EntitySightData data = this.lastEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosZ());
        }));
        list.add(new AbstractListener.CustomVariable("entity_uuid", () -> {
            OnEntityStartsBeingInSightListener.EntitySightData data = this.lastEntityData;
            if (data == null) {
                return "ERROR";
            }
            return data.entityUuid().toString();
        }));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.m_237115_((String)"fancymenu.listeners.on_entity_stops_being_in_sight");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_entity_stops_being_in_sight.desc", new String[0]));
    }
}

