/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MouseClickedRequirement
extends LoadingRequirement {
    public MouseClickedRequirement() {
        super("mouse_click");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        boolean isLeft = true;
        if (value != null && value.trim().equalsIgnoreCase("right")) {
            isLeft = false;
        }
        boolean isMouseDown = isLeft ? MouseInput.isLeftMouseDown() : MouseInput.isRightMouseDown();
        return isMouseDown;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.requirements.mouse_click", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.mouse_click.desc", new String[0]));
    }

    @Override
    @Nullable
    public String getCategory() {
        return null;
    }

    @Override
    @Nullable
    public String getValueDisplayName() {
        return I18n.m_118938_((String)"fancymenu.requirements.mouse_click.value_name", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public String getValuePreset() {
        return "left";
    }

    @Override
    @Nullable
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

