/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util.stack;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.client.ClientResourceData;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityEmiStack
extends EmiStack {
    @Nullable
    private final Entity entity;
    private final EntityRenderContext ctx;
    private int offsetY = 0;

    protected EntityEmiStack(@Nullable Entity entity) {
        this(entity, 8.0);
    }

    protected EntityEmiStack(@Nullable Entity entity, double scale) {
        this.entity = entity;
        if (entity != null) {
            boolean hasTransform = ClientResourceData.MOB_ROTATIONS.containsKey(entity.m_6095_());
            Vector3f transform = ClientResourceData.MOB_ROTATIONS.getOrDefault(entity.m_6095_(), new Vector3f(0.0f, 0.0f, 0.0f)).mul((float)Math.PI / 180);
            this.ctx = new EntityRenderContext(scale, hasTransform, transform);
        } else {
            this.ctx = new EntityRenderContext(scale, false, new Vector3f(0.0f, 0.0f, 0.0f));
        }
    }

    public static EntityEmiStack of(@Nullable Entity entity) {
        return new EntityEmiStack(entity);
    }

    public static EntityEmiStack ofScaled(@Nullable Entity entity, double scale) {
        return new EntityEmiStack(entity, scale);
    }

    public EmiStack copy() {
        EntityEmiStack stack = new EntityEmiStack(this.entity);
        stack.setRemainder(this.getRemainder().copy());
        stack.comparison = this.comparison;
        return stack;
    }

    public boolean isEmpty() {
        return this.entity == null;
    }

    public EntityEmiStack setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    public void render(GuiGraphics matrices, int x, int y, float delta, int flags) {
        block5: {
            try {
                y += this.offsetY;
                if (this.entity != null) {
                    Entity entity = this.entity;
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        EntityEmiStack.renderEntity(matrices.m_280168_(), x + 8, (int)((double)(y + 8) + this.ctx.size), this.ctx, living);
                    } else {
                        EntityEmiStack.renderEntity(matrices.m_280168_(), (int)((double)x + 2.0 * this.ctx.size / 2.0), (int)((double)y + 2.0 * this.ctx.size), this.ctx, this.entity);
                    }
                }
            }
            catch (Throwable e) {
                if (!EMILoot.DEBUG || Util.m_137550_() % 1000L != 0L) break block5;
                EMILoot.LOGGER.error("Rendering error for entity stack" + this.toString());
            }
        }
    }

    public CompoundTag getNbt() {
        return null;
    }

    public Object getKey() {
        return this.getId();
    }

    public ResourceLocation getId() {
        if (this.entity == null) {
            throw new RuntimeException("Entity is null");
        }
        return BuiltInRegistries.f_256780_.m_7981_((Object)this.entity.m_6095_());
    }

    public List<Component> getTooltipText() {
        return List.of(this.getName());
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList<ClientTooltipComponent> list = new ArrayList<ClientTooltipComponent>();
        if (this.entity != null) {
            list.addAll(this.getTooltipText().stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).toList());
            EmiTooltipComponents.appendModName(list, (String)BuiltInRegistries.f_256780_.m_7981_((Object)this.entity.m_6095_()).m_135827_());
            if (!this.getRemainder().isEmpty()) {
                list.add(EmiTooltipComponents.getRemainderTooltipComponent((EmiIngredient)this));
            }
        }
        return list;
    }

    public Component getName() {
        return this.entity != null ? this.entity.m_7755_() : LText.literal("yet another missingno");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renderEntity(PoseStack matrices, int x, int y, EntityRenderContext ctx, LivingEntity entity) {
        Minecraft client = Minecraft.m_91087_();
        double width = client.m_91268_().m_85445_();
        double height = client.m_91268_().m_85446_();
        float mouseX = (float)(client.f_91067_.m_91589_() * width / (double)client.m_91268_().m_85443_());
        float mouseY = (float)(client.f_91067_.m_91594_() * height / (double)client.m_91268_().m_85444_());
        double posX = (double)mouseX - width / 2.0 + 63.0;
        if (Double.isNaN(posX)) {
            return;
        }
        double posY = (double)mouseY - height / 2.0;
        if (Double.isNaN(posY)) {
            return;
        }
        float f = (float)Math.atan(-posX / 40.0);
        float g = (float)Math.atan(-posY / 40.0);
        PoseStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.m_85836_();
        matrixStack.m_252931_(matrices.m_85850_().m_252922_());
        matrixStack.m_85837_((double)x, (double)y, 1050.0);
        matrixStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixStack2 = new PoseStack();
        matrixStack2.m_85837_(0.0, 0.0, 1000.0);
        matrixStack2.m_85841_((float)ctx.size, (float)ctx.size, (float)ctx.size);
        Quaternionf quaternion = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternion2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180) * Mth.m_14089_((float)ctx.transform.z) - f * 20.0f * ((float)Math.PI / 180) * Mth.m_14031_((float)ctx.transform.z));
        if (ctx.hasTransform) {
            Quaternionf quaternion3 = new Quaternionf().rotateXYZ(ctx.transform.x, ctx.transform.y, ctx.transform.z);
            quaternion.mul((Quaternionfc)quaternion3);
        }
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack2.m_252781_(quaternion);
        float h = entity.f_20883_;
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        float k = entity.f_20886_;
        float l = entity.f_20885_;
        entity.f_20883_ = 180.0f + (f * 20.0f * Mth.m_14089_((float)ctx.transform.z) + g * 20.0f * Mth.m_14031_((float)ctx.transform.z));
        float yaw = 180.0f + (f * 40.0f * Mth.m_14089_((float)ctx.transform.z) + g * 40.0f * Mth.m_14031_((float)ctx.transform.z));
        entity.m_146922_(yaw);
        float pitch = -g * 20.0f * Mth.m_14089_((float)ctx.transform.z) + -f * 20.0f * Mth.m_14031_((float)ctx.transform.z);
        entity.m_146926_(pitch);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        try {
            RenderSystem.runAsFancy(() -> entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (MultiBufferSource)immediate, 0xF000F0));
        }
        finally {
            immediate.m_109911_();
        }
        entityRenderDispatcher.m_114468_(true);
        entity.f_20883_ = h;
        entity.m_146922_(i);
        entity.m_146926_(j);
        entity.f_20886_ = k;
        entity.f_20885_ = l;
        matrixStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renderEntity(PoseStack matrices, int x, int y, EntityRenderContext ctx, Entity entity) {
        Minecraft client = Minecraft.m_91087_();
        MouseHandler mouse = client.f_91067_;
        float w = 1920.0f;
        float h = 1080.0f;
        Screen screen = client.f_91080_;
        if (screen != null) {
            w = screen.f_96543_;
            h = screen.f_96544_;
        }
        float mouseX = (float)((double)(w + 51.0f) - mouse.m_91589_());
        float mouseY = (float)((double)(h + 75.0f - 50.0f) - mouse.m_91594_());
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        PoseStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.m_85836_();
        matrixStack.m_252931_(matrices.m_85850_().m_252922_());
        matrixStack.m_85837_((double)x, (double)y, 1050.0);
        matrixStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixStack2 = new PoseStack();
        matrixStack2.m_85837_(0.0, 0.0, 1000.0);
        matrixStack2.m_85841_((float)ctx.size, (float)ctx.size, (float)ctx.size);
        Quaternionf quaternion = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternion2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180) * Mth.m_14089_((float)ctx.transform.z) - f * 20.0f * ((float)Math.PI / 180) * Mth.m_14031_((float)ctx.transform.z));
        if (ctx.hasTransform) {
            Quaternionf quaternion3 = new Quaternionf().rotateXYZ(ctx.transform.x, ctx.transform.y, ctx.transform.z);
            quaternion.mul((Quaternionfc)quaternion3);
        }
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack2.m_252781_(quaternion);
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        entity.m_146922_(180.0f + (f * 40.0f * Mth.m_14089_((float)ctx.transform.z) + g * 40.0f * Mth.m_14031_((float)ctx.transform.z)));
        entity.m_146926_(-g * 20.0f * Mth.m_14089_((float)ctx.transform.z) + -f * 20.0f * Mth.m_14031_((float)ctx.transform.z));
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        try {
            RenderSystem.runAsFancy(() -> entityRenderDispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (MultiBufferSource)immediate, 0xF000F0));
        }
        finally {
            immediate.m_109911_();
        }
        entityRenderDispatcher.m_114468_(true);
        entity.m_146922_(i);
        entity.m_146926_(j);
        matrixStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    private record EntityRenderContext(double size, boolean hasTransform, Vector3f transform) {
        static EntityRenderContext EMPTY = new EntityRenderContext(8.0, false, new Vector3f(0.0f, 0.0f, 0.0f));
    }
}

