/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.registry.common.LodestoneWorldEventTypeRegistry;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class WorldEventTypeArgument
implements ArgumentType<WorldEventType> {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_WORLD_EVENT_TYPE = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"argument.lodestone.id.invalid", (Object[])new Object[]{object.toString()}));

    protected WorldEventTypeArgument() {
    }

    public static WorldEventTypeArgument worldEventType() {
        return new WorldEventTypeArgument();
    }

    public static WorldEventType getEventType(CommandContext<?> context, String name) {
        return (WorldEventType)context.getArgument(name, WorldEventType.class);
    }

    public WorldEventType parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation resourceLocation = ResourceLocation.m_135818_((StringReader)reader);
        WorldEventType worldEventType = LodestoneWorldEventTypeRegistry.EVENT_TYPES.get(resourceLocation);
        if (worldEventType != null) {
            return worldEventType;
        }
        throw ERROR_UNKNOWN_WORLD_EVENT_TYPE.create((Object)resourceLocation);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (WorldEventType type : LodestoneWorldEventTypeRegistry.EVENT_TYPES.values()) {
            if (type == null) continue;
            builder.suggest(type.id.toString());
        }
        return builder.buildFuture();
    }
}

