/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import mcjty.lib.compat.patchouli.PatchouliCompatibility;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record PacketOpenManual(ResourceLocation manual, ResourceLocation entry, Integer page) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("mcjtylib", "openmanual");

    public static PacketOpenManual create(FriendlyByteBuf buf) {
        ResourceLocation manual = buf.m_130281_();
        ResourceLocation entry = buf.m_130281_();
        Integer page = buf.readInt();
        return new PacketOpenManual(manual, entry, page);
    }

    public static Object create(ResourceLocation manual, ResourceLocation entry, int page) {
        return new PacketOpenManual(manual, entry, page);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.manual);
        buf.m_130085_(this.entry);
        buf.writeInt(this.page.intValue());
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> PacketOpenManual.handle(this, ctx));
    }

    private static void handle(PacketOpenManual message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> PatchouliCompatibility.openBookEntry((ServerPlayer)player, message.manual, message.entry, message.page));
    }
}

