/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.RenderTypeRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.model.LodestoneArmorModel;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class MalignantStrongholdArmorModel
extends LodestoneArmorModel {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(MalumMod.malumPath("malignant_lead_armor"), "main");
    public static final RenderTypeToken GLOW_TEXTURE = RenderTypeToken.createToken((ResourceLocation)MalumMod.malumPath("textures/armor/malignant_stronghold_glow.png"));
    private final ModelPart right_arm_glow;
    private final ModelPart left_arm_glow;
    private final ModelPart right_boot_glow;
    private final ModelPart left_boot_glow;
    private final ModelPart helmet_glow;
    private final ModelPart torso_glow;
    private final List<MalumSpiritType> activeGlows = new ArrayList<MalumSpiritType>();

    public MalignantStrongholdArmorModel(ModelPart root) {
        super(root);
        this.right_arm_glow = root.m_171324_("right_arm_glow");
        this.left_arm_glow = root.m_171324_("left_arm_glow");
        this.right_boot_glow = root.m_171324_("right_boot_glow");
        this.left_boot_glow = root.m_171324_("left_boot_glow");
        this.helmet_glow = root.m_171324_("helmet_glow");
        this.torso_glow = root.m_171324_("torso_glow");
    }

    protected List<ModelPart> getGlowingParts() {
        if (this.slot == EquipmentSlot.CHEST) {
            return ImmutableList.of((Object)this.torso_glow, (Object)this.left_arm_glow, (Object)this.right_arm_glow);
        }
        if (this.slot == EquipmentSlot.HEAD) {
            return ImmutableList.of((Object)this.helmet_glow);
        }
        return this.slot == EquipmentSlot.FEET ? ImmutableList.of((Object)this.left_boot_glow, (Object)this.right_boot_glow) : ImmutableList.of();
    }

    public void updateGlow(List<AbstractRuneCurioItem> runes) {
        this.activeGlows.clear();
        this.activeGlows.addAll(runes.stream().map(r -> r.spiritType).toList());
    }

    public static Color colorLerp(Easing easing, float pct, float[] hsv1, float[] hsv2) {
        pct = Mth.m_14036_((float)pct, (float)0.0f, (float)1.0f);
        float ease = easing.ease(pct, 0.0f, 1.0f, 1.0f);
        float h = Mth.m_14189_((float)ease, (float)(360.0f * hsv1[0]), (float)(360.0f * hsv2[0])) / 360.0f;
        float s = Mth.m_14179_((float)ease, (float)hsv1[1], (float)hsv2[1]);
        float v = Mth.m_14179_((float)ease, (float)hsv1[2], (float)hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.m_13665_((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)packed) / 255.0f;
        return new Color(r, g, b);
    }

    public static Color multicolorLerp(Easing easing, float pct, List<Color> colors) {
        pct = Mth.m_14036_((float)pct, (float)0.0f, (float)1.0f);
        int colorCount = colors.size() - 1;
        float lerp = easing.ease(pct, 0.0f, 1.0f, 1.0f);
        float colorIndex = (float)colorCount * lerp;
        int index = (int)Mth.m_14036_((float)colorIndex, (float)0.0f, (float)colorCount);
        Color color = colors.get(index);
        Color nextColor = index == colorCount ? color : colors.get(index + 1);
        float[] hsv1 = new float[3];
        float[] hsv2 = new float[3];
        Color.RGBtoHSB(Math.min(255, color.getRed()), Math.min(255, color.getGreen()), Math.min(255, color.getBlue()), hsv1);
        Color.RGBtoHSB(Math.min(255, nextColor.getRed()), Math.min(255, nextColor.getGreen()), Math.min(255, nextColor.getBlue()), hsv2);
        return MalignantStrongholdArmorModel.colorLerp(easing, colorIndex - (float)((int)colorIndex), hsv1, hsv2);
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        super.m_7695_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        if (!this.f_102610_ && !this.activeGlows.isEmpty()) {
            List<ModelPart> glowingParts = this.getGlowingParts();
            if (glowingParts.isEmpty()) {
                return;
            }
            pPoseStack.m_85836_();
            float gameTime = (float)Minecraft.m_91087_().f_91073_.m_46467_() + Minecraft.m_91087_().getPartialTick();
            Color primaryColor = this.activeGlows.get(0).getPrimaryColor();
            Color secondaryColor = this.activeGlows.get(0).getSecondaryColor();
            float colorCoefficient = this.activeGlows.get(0).getColorCoefficient();
            if (this.activeGlows.size() > 1) {
                this.activeGlows.add(this.activeGlows.get(0));
                float loopTime = 100 * this.activeGlows.size();
                float pct = gameTime % loopTime / loopTime;
                float relative = pct * (float)this.activeGlows.size();
                primaryColor = MalignantStrongholdArmorModel.multicolorLerp(Easing.LINEAR, pct, this.activeGlows.stream().map(MalumSpiritType::getPrimaryColor).collect(Collectors.toList()));
                secondaryColor = MalignantStrongholdArmorModel.multicolorLerp(Easing.LINEAR, pct, this.activeGlows.stream().map(MalumSpiritType::getSecondaryColor).collect(Collectors.toList()));
                colorCoefficient = this.activeGlows.size() == 1 ? this.activeGlows.get(0).getColorCoefficient() : Mth.m_14179_((float)(relative % (float)this.activeGlows.size()), (float)this.activeGlows.get((int)relative).getColorCoefficient(), (float)this.activeGlows.get(Math.min((int)relative + 1, this.activeGlows.size() - 1)).getColorCoefficient());
            }
            VertexConsumer transparent = RenderHandler.DELAYED_RENDER.getTarget().m_6299_((RenderType)LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.applyAndCache(GLOW_TEXTURE));
            VertexConsumer additive = RenderHandler.DELAYED_RENDER.getTarget().m_6299_((RenderType)RenderTypeRegistry.MALIGNANT_GLOW.applyAndCache(GLOW_TEXTURE));
            float distance = 0.06f;
            float alpha = 0.25f;
            int time = 320;
            for (ModelPart glowingPart : glowingParts) {
                glowingPart.m_104306_(pPoseStack, transparent, pPackedLight, pPackedOverlay, (float)primaryColor.getRed() / 255.0f, (float)primaryColor.getGreen() / 255.0f, (float)primaryColor.getBlue() / 255.0f, 0.6f);
            }
            for (int i = 0; i < 8; ++i) {
                double angle = (double)((float)i / 4.0f) * (Math.PI * 2);
                angle += (double)(gameTime % (float)time / (float)time) * (Math.PI * 2);
                for (ModelPart glowingPart : glowingParts) {
                    double sin = Math.sin(angle);
                    Color color = ColorHelper.colorLerp((Easing)Easing.SINE_IN, (float)Math.min(1.0f, (float)i / 2.0f / colorCoefficient), (Color)secondaryColor, (Color)primaryColor);
                    float yaw = glowingPart.f_104204_;
                    float pitch = -glowingPart.f_104203_;
                    if (glowingPart.equals(this.helmet_glow)) {
                        yaw += 1.57f;
                    }
                    Vec3 forward = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
                    if (!glowingPart.equals(this.helmet_glow)) {
                        Vec3 direction = new Vec3(Math.cos(yaw) * Math.cos(pitch), Math.sin(yaw) * Math.cos(pitch), Math.sin(pitch));
                        forward = forward.m_82537_(direction).m_82520_(0.0, 1.0, 0.0);
                    }
                    Vec3 offset = forward.m_82496_(pitch).m_82541_().m_82490_((double)distance * sin);
                    pPoseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                    glowingPart.m_104306_(pPoseStack, additive, 0xF000F0, pPackedOverlay, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha);
                    pPoseStack.m_85837_(-offset.f_82479_, -offset.f_82480_, -offset.f_82481_);
                }
                if (i != 3) continue;
                distance *= 2.5f;
                alpha *= 0.35f;
            }
            pPoseStack.m_85849_();
        }
    }

    public void copyFromDefault(HumanoidModel model) {
        super.copyFromDefault(model);
        this.left_arm_glow.m_104315_(model.f_102812_);
        this.right_arm_glow.m_104315_(model.f_102811_);
        this.left_boot_glow.m_104315_(model.f_102814_);
        this.right_boot_glow.m_104315_(model.f_102813_);
        this.helmet_glow.m_104315_(model.f_102808_);
        this.torso_glow.m_104315_(model.f_102810_);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.0f), (float)0.0f);
        PartDefinition root = MalignantStrongholdArmorModel.createHumanoidAlias((MeshDefinition)mesh);
        PartDefinition right_arm_glow = root.m_171599_("right_arm_glow", new CubeListBuilder(), PartPose.f_171404_);
        PartDefinition left_arm_glow = root.m_171599_("left_arm_glow", new CubeListBuilder(), PartPose.f_171404_);
        PartDefinition right_foot_glow = root.m_171599_("right_boot_glow", new CubeListBuilder(), PartPose.f_171404_);
        PartDefinition left_foot_glow = root.m_171599_("left_boot_glow", new CubeListBuilder(), PartPose.f_171404_);
        PartDefinition helmet_glow = root.m_171599_("helmet_glow", new CubeListBuilder(), PartPose.f_171404_);
        PartDefinition torso_glow = root.m_171599_("torso_glow", new CubeListBuilder(), PartPose.f_171404_);
        PartDefinition body = root.m_171597_("body");
        PartDefinition leggings = root.m_171597_("leggings");
        PartDefinition right_legging = root.m_171597_("right_legging");
        PartDefinition left_legging = root.m_171597_("left_legging");
        PartDefinition right_foot = root.m_171597_("right_foot");
        PartDefinition left_foot = root.m_171597_("left_foot");
        PartDefinition right_arm = root.m_171597_("right_arm");
        PartDefinition left_arm = root.m_171597_("left_arm");
        PartDefinition head = root.m_171597_("head");
        PartDefinition front_glow = torso_glow.m_171599_("front_glow", CubeListBuilder.m_171558_().m_171514_(105, 4).m_171488_(-1.5f, 1.5f, -5.9f, 3.0f, 3.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition back_glow = torso_glow.m_171599_("back_glow", CubeListBuilder.m_171558_().m_171514_(95, 4).m_171488_(-1.5f, 3.5f, 2.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition helmet_glow_left = helmet_glow.m_171599_("helmet_glow_left", CubeListBuilder.m_171558_().m_171514_(106, 0).m_171480_().m_171488_(4.6846f, -10.0f, -1.2529f, 2.0f, 5.0f, 9.0f, new CubeDeformation(-0.5f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition helmet_glow_right = helmet_glow.m_171599_("helmet_glow_right", CubeListBuilder.m_171558_().m_171514_(106, 0).m_171480_().m_171488_(-6.6846f, -10.0f, -1.2529f, 2.0f, 5.0f, 9.0f, new CubeDeformation(-0.5f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition helmet = head.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-4.5f, -8.0f, -5.0f, 3.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(6, 40).m_171488_(-5.5f, -8.0f, -5.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(26, 34).m_171488_(-4.5f, -8.0f, -5.0f, 3.0f, 3.0f, 10.0f, new CubeDeformation(0.25f)).m_171514_(0, 47).m_171488_(-4.5f, -5.0f, 1.0f, 9.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(26, 47).m_171488_(-4.5f, -5.0f, 1.0f, 9.0f, 5.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(0, 34).m_171480_().m_171488_(1.5f, -8.0f, -5.0f, 3.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(6, 40).m_171480_().m_171488_(4.5f, -8.0f, -5.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(26, 34).m_171480_().m_171488_(1.5f, -8.0f, -5.0f, 3.0f, 3.0f, 10.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(0, 0).m_171488_(-1.5f, -10.0f, -6.0f, 3.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 3).m_171488_(-2.5f, -13.0f, -6.0f, 5.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(30, 0).m_171488_(-1.5f, -10.0f, -6.0f, 3.0f, 6.0f, 12.0f, new CubeDeformation(0.25f)).m_171514_(0, 18).m_171488_(-5.5f, -11.0f, -3.0f, 2.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171480_().m_171488_(3.5f, -11.0f, -3.0f, 2.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(22, 18).m_171488_(-5.5f, -11.0f, -3.0f, 2.0f, 7.0f, 9.0f, new CubeDeformation(0.25f)).m_171514_(22, 18).m_171480_().m_171488_(3.5f, -11.0f, -3.0f, 2.0f, 7.0f, 9.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(18, 3).m_171488_(-5.0f, -5.0f, -5.0f, 2.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(18, 3).m_171480_().m_171488_(3.0f, -5.0f, -5.0f, 2.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(30, 3).m_171480_().m_171488_(3.0f, -5.0f, -5.0f, 2.0f, 5.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(30, 3).m_171488_(-5.0f, -5.0f, -5.0f, 2.0f, 5.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(30, 4).m_171488_(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(30, 4).m_171480_().m_171488_(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(-5.0f, 2.0f, -3.0f, 10.0f, 5.0f, 6.0f, new CubeDeformation(0.025f)).m_171514_(0, 80).m_171488_(-4.5f, 6.5f, -2.5f, 9.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition thing = torso.m_171599_("thing", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171488_(-6.0f, -1.0f, -5.0f, 12.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(42, 56).m_171488_(-6.0f, -1.0f, -5.0f, 12.0f, 4.0f, 9.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0f, (float)0.05f, (float)0.075f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_shoulder = left_arm.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171514_(0, 89).m_171488_(0.0f, -4.5f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.01f)).m_171514_(22, 89).m_171488_(0.0f, -4.5f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.26f)).m_171514_(44, 89).m_171488_(0.0f, -5.5f, -3.0f, 3.0f, 1.0f, 6.0f, new CubeDeformation(0.01f)).m_171514_(62, 89).m_171488_(0.0f, -5.5f, -3.0f, 3.0f, 1.0f, 6.0f, new CubeDeformation(0.27f)).m_171514_(0, 111).m_171488_(-1.5f, 5.0f, -3.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.01f)).m_171514_(22, 111).m_171488_(-1.5f, 5.0f, -3.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.26f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_shoulder_pad = left_shoulder.m_171599_("left_shoulder_pad", CubeListBuilder.m_171558_().m_171514_(0, 100).m_171488_(1.8918f, -1.4881f, -4.0f, 6.0f, 3.0f, 8.0f, new CubeDeformation(0.01f)).m_171514_(28, 100).m_171488_(1.8918f, -1.4881f, -4.0f, 6.0f, 3.0f, 8.0f, new CubeDeformation(0.26f)), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition right_shoulder = right_arm.m_171599_("right_shoulder", CubeListBuilder.m_171558_().m_171514_(0, 89).m_171480_().m_171488_(-5.0f, -4.5f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.01f)).m_171555_(false).m_171514_(44, 89).m_171480_().m_171488_(-3.0f, -5.5f, -3.0f, 3.0f, 1.0f, 6.0f, new CubeDeformation(0.01f)).m_171555_(false).m_171514_(62, 89).m_171480_().m_171488_(-3.0f, -5.5f, -3.0f, 3.0f, 1.0f, 6.0f, new CubeDeformation(0.27f)).m_171555_(false).m_171514_(22, 89).m_171480_().m_171488_(-5.0f, -4.5f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.26f)).m_171555_(false).m_171514_(0, 111).m_171480_().m_171488_(-3.5f, 5.0f, -3.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.01f)).m_171555_(false).m_171514_(22, 111).m_171480_().m_171488_(-3.5f, 5.0f, -3.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.26f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_shoulder_pad = right_shoulder.m_171599_("right_shoulder_pad", CubeListBuilder.m_171558_().m_171514_(0, 100).m_171480_().m_171488_(-7.6753f, -1.4644f, -4.0f, 6.0f, 3.0f, 8.0f, new CubeDeformation(0.01f)).m_171555_(false).m_171514_(28, 100).m_171480_().m_171488_(-7.6753f, -1.4644f, -4.0f, 6.0f, 3.0f, 8.0f, new CubeDeformation(0.26f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition left_shoulder_glow = left_arm_glow.m_171599_("left_shoulder_glow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_shoulder_upper_glow = left_shoulder_glow.m_171599_("left_shoulder_upper_glow", CubeListBuilder.m_171558_().m_171514_(116, 22).m_171488_(6.0f, -4.75f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(-0.24f)).m_171514_(89, 5).m_171488_(4.0f, -2.25f, -3.75f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.01f)).m_171514_(89, 5).m_171488_(4.0f, -2.25f, 2.75f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition left_shoulder_lower_glow = left_shoulder_glow.m_171599_("left_shoulder_lower_glow", CubeListBuilder.m_171558_().m_171514_(116, 14).m_171488_(3.5f, 4.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(-0.23f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_shoulder_glow = right_arm_glow.m_171599_("right_shoulder_glow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_shoulder_upper_glow = right_shoulder_glow.m_171599_("right_shoulder_upper_glow", CubeListBuilder.m_171558_().m_171514_(116, 22).m_171480_().m_171488_(-9.0f, -5.75f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(-0.24f)).m_171555_(false).m_171514_(89, 5).m_171480_().m_171488_(-6.0f, -3.25f, -3.75f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.01f)).m_171555_(false).m_171514_(89, 5).m_171480_().m_171488_(-6.0f, -3.25f, 2.75f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition right_shoulder_lower_glow = right_shoulder_glow.m_171599_("right_shoulder_lower_glow", CubeListBuilder.m_171558_().m_171514_(116, 14).m_171480_().m_171488_(-6.5f, 4.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(-0.23f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = left_legging.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(84, 116).m_171480_().m_171488_(-2.4f, -0.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_thigh_guard1 = left_leg.m_171599_("left_thigh_guard1", CubeListBuilder.m_171558_().m_171514_(48, 117).m_171480_().m_171488_(1.3934f, -1.1278f, -3.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.03f)).m_171555_(false).m_171514_(48, 106).m_171480_().m_171488_(1.3934f, -1.1278f, -3.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.28f)).m_171555_(false), PartPose.m_171423_((float)0.1f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        PartDefinition left_thigh_guard2 = left_leg.m_171599_("left_thigh_guard2", CubeListBuilder.m_171558_().m_171514_(66, 115).m_171480_().m_171488_(-0.2266f, -2.8943f, -3.0f, 3.0f, 7.0f, 6.0f, new CubeDeformation(0.02f)).m_171555_(false).m_171514_(66, 102).m_171480_().m_171488_(-0.2266f, -2.8943f, -3.0f, 3.0f, 7.0f, 6.0f, new CubeDeformation(0.27f)).m_171555_(false), PartPose.m_171423_((float)1.1f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        PartDefinition right_leg = right_legging.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(84, 116).m_171488_(-2.6f, -0.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_thigh_guard1 = right_leg.m_171599_("right_thigh_guard1", CubeListBuilder.m_171558_().m_171514_(48, 117).m_171488_(-4.3934f, -1.1278f, -3.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.03f)).m_171514_(48, 106).m_171488_(-4.3934f, -1.1278f, -3.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.28f)), PartPose.m_171423_((float)-0.1f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1345f));
        PartDefinition right_thigh_guard2 = right_leg.m_171599_("right_thigh_guard2", CubeListBuilder.m_171558_().m_171514_(66, 115).m_171488_(-2.7734f, -2.8943f, -3.0f, 3.0f, 7.0f, 6.0f, new CubeDeformation(0.02f)).m_171514_(66, 102).m_171488_(-2.7734f, -2.8943f, -3.0f, 3.0f, 7.0f, 6.0f, new CubeDeformation(0.27f)), PartPose.m_171423_((float)-1.1f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1345f));
        PartDefinition codpiece = leggings.m_171599_("codpiece", CubeListBuilder.m_171558_().m_171514_(32, 72).m_171488_(-4.0f, -14.5f, -3.0f, 8.0f, 2.0f, 6.0f, new CubeDeformation(0.04f)).m_171514_(60, 72).m_171488_(-4.0f, -14.5f, -3.0f, 8.0f, 2.0f, 6.0f, new CubeDeformation(0.29f)).m_171514_(28, 80).m_171488_(-2.0f, -12.5f, -3.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.04f)).m_171514_(48, 80).m_171488_(-2.0f, -12.5f, -3.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.29f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_boot = left_foot.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(104, 115).m_171488_(-2.9f, 6.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.01f)).m_171514_(104, 102).m_171488_(-2.9f, 6.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.26f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_boot = right_foot.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(104, 115).m_171480_().m_171488_(-3.1f, 6.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(104, 102).m_171480_().m_171488_(-3.1f, 6.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_boot_glow = left_foot_glow.m_171599_("left_boot_glow", CubeListBuilder.m_171558_().m_171514_(106, 14).m_171488_(2.6f, 6.5f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(-0.24f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_boot_glow = right_foot_glow.m_171599_("right_boot_glow", CubeListBuilder.m_171558_().m_171514_(106, 14).m_171480_().m_171488_(-4.6f, 6.5f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(-0.25f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }
}

