/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.screens;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.handlers.BookObjectHandler;
import com.sammy.malum.client.screen.codex.objects.ArrowObject;
import com.sammy.malum.client.screen.codex.objects.LinkedEntryObject;
import com.sammy.malum.client.screen.codex.objects.progression.ProgressionEntryObject;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.AbstractProgressionCodexScreen;
import com.sammy.malum.config.ClientConfig;
import com.sammy.malum.registry.common.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class EntryScreen
extends AbstractMalumScreen {
    public static EntryScreen entryScreen;
    public static final ResourceLocation BOOK_TEXTURE;
    public static final ResourceLocation ELEMENT_SOCKET;
    public final int bookWidth = 312;
    public final int bookHeight = 200;
    public final BookEntry openEntry;
    protected final Consumer<Boolean> onClose;
    public final BookObjectHandler<EntryScreen> bookObjectHandler = new BookObjectHandler();
    public List<Runnable> lateRendering = new ArrayList<Runnable>();
    public int grouping;

    public EntryScreen(BookEntry openEntry, Consumer<Boolean> onClose) {
        super((Component)Component.m_237119_(), (Supplier<SoundEvent>)(openEntry.isVoid ? SoundRegistry.ARCANA_SWEETENER_EVIL : SoundRegistry.ARCANA_SWEETENER_NORMAL));
        this.openEntry = openEntry;
        this.onClose = onClose;
        int left = -21;
        int right = 297;
        this.bookObjectHandler.add(new ArrowObject(-21, 150, false));
        this.bookObjectHandler.add(new ArrowObject(297, 150, true));
        ImmutableList<EntryReference> references = openEntry.references;
        if (references != null) {
            int counter = 0;
            for (int i = 0; i < references.size(); ++i) {
                EntryReference entryReference = (EntryReference)references.get(i);
                if (!entryReference.entry.shouldShow()) continue;
                this.bookObjectHandler.add(new LinkedEntryObject(297, 15 + counter * 30, true, entryReference));
                ++counter;
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int pageTop;
        int pageLeft;
        boolean isRightSide;
        BookPage page;
        int openPages;
        int i;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        PoseStack poseStack = guiGraphics.m_280168_();
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        ArcanaCodexHelper.renderTexture(BOOK_TEXTURE, poseStack, guiLeft, guiTop, 0.0f, 0.0f, 312, 200);
        if (!this.openEntry.pages.isEmpty()) {
            for (i = openPages = this.grouping * 2; i < openPages + 2; ++i) {
                if (i >= this.openEntry.pages.size()) continue;
                page = (BookPage)this.openEntry.pages.get(i);
                isRightSide = i % 2 == 1;
                pageLeft = guiLeft + (isRightSide ? 161 : 9);
                pageTop = guiTop + 8;
                ResourceLocation background = page.getBackground(isRightSide);
                if (background == null) continue;
                ArcanaCodexHelper.renderTexture(background, poseStack, pageLeft, pageTop, 0.0f, 0.0f, 142, 172);
            }
        }
        this.bookObjectHandler.renderObjects(this, guiGraphics, guiLeft, guiTop, mouseX, mouseY, partialTicks);
        if (!this.openEntry.pages.isEmpty()) {
            for (i = openPages = this.grouping * 2; i < openPages + 2; ++i) {
                if (i >= this.openEntry.pages.size()) continue;
                page = (BookPage)this.openEntry.pages.get(i);
                isRightSide = i % 2 == 1;
                pageLeft = guiLeft + (isRightSide ? 161 : 9);
                pageTop = guiTop + 8;
                boolean isRepeat = i % 2 != 0 && page.getClass().equals(((BookPage)this.openEntry.pages.get(i - 1)).getClass());
                page.render(this, guiGraphics, pageLeft, pageTop, mouseX, mouseY, partialTicks, isRepeat);
                this.lateRendering.add(() -> page.renderLate(this, guiGraphics, pageLeft, pageTop, mouseX, mouseY, partialTicks, isRepeat));
            }
            this.lateRendering.forEach(Runnable::run);
            this.lateRendering.clear();
        }
        this.bookObjectHandler.renderObjectsLate(this, guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.bookObjectHandler.click(this, mouseX, mouseY);
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        if (!this.openEntry.pages.isEmpty()) {
            int openPages;
            for (int i = openPages = this.grouping * 2; i < openPages + 2; ++i) {
                int pageTop;
                if (i >= this.openEntry.pages.size()) continue;
                BookPage page = (BookPage)this.openEntry.pages.get(i);
                boolean isRightSide = i % 2 == 1;
                int pageLeft = guiLeft + (isRightSide ? 161 : 9);
                if (!this.isHovering(mouseX, mouseY, pageLeft, pageTop = guiTop + 8, 142, 172)) continue;
                double relativeX = Mth.m_14008_((double)(mouseX - (double)guiLeft), (double)guiLeft, (double)(guiLeft + 142));
                double relativeY = Mth.m_14008_((double)(mouseY - (double)guiTop), (double)guiTop, (double)(guiTop + 172));
                page.click(this, pageLeft, pageTop, mouseX, mouseY, relativeX, relativeY);
            }
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (((Boolean)ClientConfig.SCROLL_DIRECTION.getConfigValue()).booleanValue()) {
            scroll = -scroll;
        }
        if (scroll > 0.0) {
            this.nextPage();
        } else {
            this.previousPage(false);
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92088_.m_90832_(keyCode, scanCode)) {
            this.nextPage();
            return true;
        }
        if (this.f_96541_.f_91066_.f_92086_.m_90832_(keyCode, scanCode)) {
            this.previousPage(false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.close(false);
    }

    public boolean hasNextPage() {
        return (float)this.grouping < (float)this.openEntry.pages.size() / 2.0f - 1.0f;
    }

    public void nextPage() {
        if (this.hasNextPage()) {
            ++this.grouping;
            this.playPageFlipSound((Supplier<SoundEvent>)SoundRegistry.ARCANA_PAGE_FLIP, this.getSweetenerPitch());
        }
    }

    public void previousPage(boolean ignore) {
        if (this.grouping > 0) {
            --this.grouping;
            this.playPageFlipSound((Supplier<SoundEvent>)SoundRegistry.ARCANA_PAGE_FLIP, this.getSweetenerPitch());
        } else {
            this.close(ignore);
        }
    }

    public void close(boolean ignoreNextInput) {
        this.onClose.accept(ignoreNextInput);
        this.playSweetenedSound((Supplier<SoundEvent>)SoundRegistry.ARCANA_ENTRY_CLOSE, 0.85f);
    }

    public static <K extends AbstractProgressionCodexScreen> void openScreen(K screen, ProgressionEntryObject progressionEntryObject) {
        EntryScreen.openScreen(progressionEntryObject.entry, (Boolean b) -> {
            screen.openScreen((boolean)b);
            progressionEntryObject.exit(screen);
        });
    }

    public static void openScreen(AbstractMalumScreen screen, BookEntry entry) {
        EntryScreen.openScreen(entry, screen::openScreen);
    }

    public static void openScreen(BookEntry bookEntry, Consumer<Boolean> onClose) {
        entryScreen = new EntryScreen(bookEntry, onClose);
        entryScreen.playSweetenedSound((Supplier<SoundEvent>)SoundRegistry.ARCANA_ENTRY_OPEN, 1.15f);
        Minecraft.m_91087_().m_91152_((Screen)entryScreen);
    }

    public float getSweetenerPitch() {
        return 1.0f + (float)this.grouping / (float)this.openEntry.pages.size();
    }

    public int getGuiLeft() {
        return (this.f_96543_ - 312) / 2;
    }

    public int getGuiTop() {
        return (this.f_96544_ - 200) / 2;
    }

    public void renderLate(Runnable runnable) {
        this.lateRendering.add(runnable);
    }

    static {
        BOOK_TEXTURE = MalumMod.malumPath("textures/gui/book/entry.png");
        ELEMENT_SOCKET = MalumMod.malumPath("textures/gui/book/entry_elements/element_socket.png");
    }
}

