/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.ether;

import com.sammy.malum.common.block.ether.EtherBrazierBlock;
import com.sammy.malum.common.block.ether.EtherTorchBlock;
import com.sammy.malum.common.block.ether.EtherWallTorchBlock;
import com.sammy.malum.common.item.ether.AbstractEtherItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public class EtherBlockEntity
extends LodestoneBlockEntity {
    public Color firstColor;
    public Color secondColor;

    public EtherBlockEntity(BlockEntityType<? extends EtherBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public EtherBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends EtherBlockEntity>)((BlockEntityType)BlockEntityRegistry.ETHER.get()), pos, state);
    }

    public void setFirstColor(int rgb) {
        this.firstColor = new Color(rgb);
    }

    public void setSecondColor(int rgb) {
        this.secondColor = new Color(rgb);
    }

    public void m_142466_(CompoundTag compound) {
        this.setFirstColor(compound.m_128441_("firstColor") ? compound.m_128451_("firstColor") : 15712278);
        Item item = this.m_58900_().m_60734_().m_5456_();
        if (item instanceof AbstractEtherItem) {
            AbstractEtherItem etherItem = (AbstractEtherItem)item;
            if (etherItem.iridescent) {
                this.setSecondColor(compound.m_128441_("secondColor") ? compound.m_128451_("secondColor") : 4607909);
            }
        }
        super.m_142466_(compound);
    }

    protected void m_183515_(CompoundTag compound) {
        Item item;
        if (this.firstColor != null) {
            compound.m_128405_("firstColor", this.firstColor.getRGB());
        }
        if ((item = this.m_58900_().m_60734_().m_5456_()) instanceof AbstractEtherItem) {
            AbstractEtherItem etherItem = (AbstractEtherItem)item;
            if (etherItem.iridescent && this.secondColor != null && this.secondColor.getRGB() != 4607909) {
                compound.m_128405_("secondColor", this.secondColor.getRGB());
            }
        }
        super.m_183515_(compound);
    }

    public void onPlace(LivingEntity placer, ItemStack stack) {
        AbstractEtherItem item = (AbstractEtherItem)stack.m_41720_();
        this.setFirstColor(item.getFirstColor(stack));
        if (item.iridescent) {
            this.setSecondColor(item.getSecondColor(stack));
        }
    }

    public ItemStack onClone(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = state.m_60734_().m_5456_().m_7968_();
        AbstractEtherItem etherItem = (AbstractEtherItem)stack.m_41720_();
        if (this.firstColor != null) {
            etherItem.setFirstColor(stack, this.firstColor.getRGB());
        }
        if (this.secondColor != null) {
            etherItem.setSecondColor(stack, this.secondColor.getRGB());
        }
        return super.onClone(state, target, level, pos, player);
    }

    public void init() {
        if (!this.f_58857_.f_46443_) {
            BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            float velocity;
            float scale;
            if (this.firstColor == null) {
                return;
            }
            RandomSource random = this.f_58857_.f_46441_;
            Block block = this.m_58900_().m_60734_();
            Color firstColor = ColorHelper.darker((Color)this.firstColor, (int)1);
            Color secondColor = this.secondColor == null ? firstColor : ColorHelper.brighter((Color)this.secondColor, (int)1);
            double x = (float)this.f_58858_.m_123341_() + 0.5f;
            double y = (float)this.f_58858_.m_123342_() + 0.5f;
            double z = (float)this.f_58858_.m_123343_() + 0.5f;
            if (block instanceof EtherWallTorchBlock) {
                float offset = 0.15f;
                Direction direction = (Direction)this.m_58900_().m_61143_((Property)WallTorchBlock.f_58119_);
                x -= (double)((float)direction.m_122436_().m_123341_() * 0.15f);
                y += (double)0.4f;
                z -= (double)((float)direction.m_122436_().m_123343_() * 0.15f);
            } else if (block instanceof EtherTorchBlock) {
                y += (double)0.3f;
            } else if (block instanceof EtherBrazierBlock) {
                y -= (double)0.05f;
            }
            ColorParticleData colorData = ColorParticleData.create((Color)firstColor, (Color)secondColor).setCoefficient(1.5f).setEasing(Easing.BOUNCE_IN_OUT).build();
            if (this.f_58857_.m_46467_() % 8L == 0L) {
                int lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)40, (int)60);
                scale = RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)0.7f);
                velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.02f, (float)0.03f);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.f_58857_, new Vec3(x, y, z), colorData);
                lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setLifetime(lifeTime).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.3f, (float)0.6f, (float)0.0f).build()).addMotion(0.0, (double)(velocity * 1.2f), 0.0);
                lightSpecs.spawnParticlesRaw();
            }
            if (this.f_58857_.m_46467_() % 2L == 0L) {
                int lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)12, (int)14);
                scale = RandomHelper.randomBetween((RandomSource)random, (float)0.16f, (float)0.2f);
                velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.02f, (float)0.03f);
                WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN).build()).setTransparencyData(GenericParticleData.create((float)0.4f, (float)0.8f, (float)0.2f).setEasing(Easing.QUAD_OUT).build()).setColorData(colorData).setSpinData(SpinParticleData.create((float)0.2f, (float)0.4f).setSpinOffset((float)this.f_58857_.m_46467_() * 0.2f % 6.28f).setEasing(Easing.QUARTIC_IN).build()).setLifetime(lifeTime).addMotion(0.0, (double)(velocity * 1.5f), 0.0).enableNoClip().spawn(this.f_58857_, x, y, z);
                lifeTime = 20;
                scale = 0.4f;
                WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.TWINKLE_PARTICLE).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).build()).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.8f).build()).setColorData(ColorParticleData.create((Color)firstColor, (Color)secondColor).setEasing(Easing.SINE_IN).setCoefficient(0.5f).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.0f, (float)0.4f).setEasing(Easing.QUARTIC_IN).build()).setLifetime(lifeTime).enableNoClip().spawn(this.f_58857_, x, y, z);
            }
            if (this.f_58857_.m_46467_() % 4L == 0L) {
                long gameTime = this.f_58857_.m_46467_();
                float scale2 = RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)0.75f);
                float velocity2 = RandomHelper.randomBetween((RandomSource)random, (float)0.0f, (float)0.02f);
                float angle = (float)(gameTime % 24L) / 24.0f * (float)Math.PI * 2.0f;
                Vec3 offset = new Vec3(Math.sin(angle), 0.0, Math.cos(angle)).m_82541_();
                Vec3 offsetPosition = new Vec3(x + offset.f_82479_ * (double)0.075f, y - (double)0.05f, z + offset.f_82481_ * (double)0.075f);
                WorldParticleBuilder.create(ParticleRegistry.SPIRIT_FLAME_PARTICLE).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setScaleData(GenericParticleData.create((float)(scale2 * 0.75f), (float)scale2, (float)0.0f).build()).setColorData(ColorParticleData.create((Color)firstColor, (Color)secondColor).setEasing(Easing.CIRC_IN_OUT).setCoefficient(2.5f).build()).setTransparencyData(GenericParticleData.create((float)0.0f, (float)1.0f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.QUAD_IN).setCoefficient(3.5f).build()).addMotion(0.0, (double)velocity2, 0.0).addTickActor(p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)(1.0f - random.m_188501_() * 0.0f)))).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawn(this.f_58857_, offsetPosition.f_82479_, offsetPosition.f_82480_, offsetPosition.f_82481_);
            }
        }
    }
}

