/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.scythe;

import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class AbstractScytheProjectileEntity
extends ThrowableItemProjectile {
    public final TrailPointBuilder theFormer = TrailPointBuilder.create((int)8);
    public final TrailPointBuilder theLatter = TrailPointBuilder.create((int)8);
    public float spinOffset = (float)((double)this.f_19796_.m_188501_() * Math.PI * 2.0);
    public int slot;
    public int age;
    protected float damage;
    protected float magicDamage;
    public int enemiesHit;
    public int returnTimer;

    public AbstractScytheProjectileEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    public AbstractScytheProjectileEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
        this.f_19794_ = true;
    }

    public void setData(Entity owner, float damage, float magicDamage, int slot, int returnTimer) {
        this.m_5602_(owner);
        this.damage = damage;
        this.magicDamage = magicDamage;
        this.slot = slot;
        this.returnTimer = returnTimer;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.slot != 0) {
            compound.m_128405_("slot", this.slot);
        }
        if (this.age != 0) {
            compound.m_128405_("age", this.age);
        }
        if (this.damage != 0.0f) {
            compound.m_128350_("damage", this.damage);
        }
        if (this.magicDamage != 0.0f) {
            compound.m_128350_("magicDamage", this.magicDamage);
        }
        if (this.enemiesHit != 0) {
            compound.m_128405_("enemiesHit", this.enemiesHit);
        }
        if (this.returnTimer != 0) {
            compound.m_128405_("returnTimer", this.returnTimer);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.slot = compound.m_128451_("slot");
        this.age = compound.m_128451_("age");
        this.damage = compound.m_128457_("damage");
        this.magicDamage = compound.m_128457_("magicDamage");
        this.enemiesHit = compound.m_128451_("enemiesHit");
        this.returnTimer = compound.m_128451_("returnTimer");
    }

    protected boolean m_5603_(Entity pTarget) {
        return !pTarget.equals((Object)this.m_19749_()) && super.m_5603_(pTarget);
    }

    protected void m_5790_(EntityHitResult result) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity scytheOwner = (LivingEntity)entity;
            Entity target = result.m_82443_();
            DamageSource source = DamageTypeHelper.create((Level)this.m_9236_(), DamageTypeRegistry.SCYTHE_SWEEP, (Entity)this, (Entity)scytheOwner);
            ItemStack heldItem = scytheOwner.m_21205_();
            scytheOwner.m_21008_(InteractionHand.MAIN_HAND, this.m_7846_());
            target.f_19802_ = 0;
            boolean success = target.m_6469_(source, this.damage);
            if (success && target instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)target;
                ItemStack scythe = this.m_7846_();
                ItemHelper.applyEnchantments((LivingEntity)scytheOwner, (Entity)livingentity, (ItemStack)scythe);
                int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)scythe);
                if (i > 0) {
                    livingentity.m_20254_(i * 4);
                }
                if (this.magicDamage > 0.0f && !livingentity.m_21224_()) {
                    livingentity.f_19802_ = 0;
                    livingentity.m_6469_(DamageTypeHelper.create((Level)this.m_9236_(), DamageTypeRegistry.VOODOO, (Entity)this, (Entity)scytheOwner), this.magicDamage);
                }
                ++this.enemiesHit;
                this.returnTimer += 2;
            }
            scytheOwner.m_21008_(InteractionHand.MAIN_HAND, heldItem);
            SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)SoundRegistry.SCYTHE_SWEEP.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)this.m_9236_().m_213780_(), (float)0.75f, (float)1.25f));
        }
        super.m_5790_(result);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.age;
        Level level = this.m_9236_();
        if (level.f_46443_) {
            this.addTrailPoints();
            this.theFormer.tickTrailPoints();
            this.theLatter.tickTrailPoints();
        } else {
            Vec3 motion = this.m_20184_();
            if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
                this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.2957763671875));
                this.f_19859_ = this.m_146908_();
                this.f_19860_ = this.m_146909_();
            }
        }
    }

    public void addTrailPoints() {
        for (int i = 0; i < 2; ++i) {
            float progress = (float)(i + 1) * 0.5f;
            Vec3 position = this.m_20318_(progress);
            float scalar = ((float)this.age + progress) / 2.0f;
            for (int j = 0; j < 2; ++j) {
                TrailPointBuilder trail = j == 0 ? this.theFormer : this.theLatter;
                double xOffset = Math.cos(this.spinOffset + 3.14f * (float)j + scalar) * (double)1.2f;
                double zOffset = Math.sin(this.spinOffset + 3.14f * (float)j + scalar) * (double)1.2f;
                trail.addTrailPoint(position.m_82520_(xOffset, 0.0, zOffset));
            }
        }
    }

    public void m_37251_(Entity shooter, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float innacuracy) {
        float f = -Mth.m_14031_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, innacuracy);
        Vec3 vec3 = shooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, 0.0, vec3.f_82481_));
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.CRUDE_SCYTHE.get();
    }

    public boolean m_20068_() {
        return true;
    }

    public float m_6143_() {
        return 4.0f;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }
}

