/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.rotten;

import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.common.item.food.ConcentratedGluttonyItem;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class CurioStarvedBelt
extends MalumCurioItem
implements IMalumEventResponderItem {
    public CurioStarvedBelt(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.ROTTEN);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(CurioStarvedBelt.positiveEffect("spirits_gluttony", new Object[0]));
    }

    @Override
    public void pickupSpirit(LivingEntity collector, double arcaneResonance) {
        MobEffect gluttony = (MobEffect)MobEffectRegistry.GLUTTONY.get();
        MobEffectInstance effect = collector.m_21124_(gluttony);
        if (effect == null) {
            collector.m_7292_(new MobEffectInstance(gluttony, (int)(600.0 * arcaneResonance), 0, true, true, true));
        } else {
            EntityHelper.amplifyEffect((MobEffectInstance)effect, (LivingEntity)collector, (int)1, (int)9);
        }
        SoundHelper.playSound((Entity)collector, (SoundEvent)((SoundEvent)SoundRegistry.HUNGRY_BELT_FEEDS.get()), (float)0.7f, (float)RandomHelper.randomBetween((RandomSource)collector.m_217043_(), (float)1.5f, (float)2.0f));
        SoundHelper.playSound((Entity)collector, (SoundEvent)SoundEvents.f_11912_, (float)0.7f, (float)RandomHelper.randomBetween((RandomSource)collector.m_217043_(), (float)0.8f, (float)1.2f));
        if (!collector.m_9236_().f_46443_) {
            ConcentratedGluttonyItem.createGluttonyVFX(collector, 0.5f);
        }
    }
}

