/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.recipe.ILodestoneRecipe;

public abstract class AbstractMalumRecipe
extends ILodestoneRecipe {
    private final ResourceLocation id;
    private final RecipeSerializer<?> recipeSerializer;
    private final RecipeType<?> recipeType;

    protected AbstractMalumRecipe(ResourceLocation id, RecipeSerializer<?> recipeSerializer, RecipeType<?> recipeType) {
        this.id = id;
        this.recipeSerializer = recipeSerializer;
        this.recipeType = recipeType;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.recipeSerializer;
    }

    public RecipeType<?> m_6671_() {
        return this.recipeType;
    }

    public static <T extends AbstractMalumRecipe> T getRecipe(Level level, RecipeType<T> recipeType, Predicate<T> predicate) {
        List<AbstractMalumRecipe> recipes = AbstractMalumRecipe.getRecipes(level, recipeType);
        for (AbstractMalumRecipe recipe : recipes) {
            if (!predicate.test(recipe)) continue;
            return (T)((Object)recipe);
        }
        return null;
    }

    public static <T extends AbstractMalumRecipe> List<T> getRecipes(Level level, RecipeType<T> recipeType) {
        return level.m_7465_().m_44013_(recipeType);
    }
}

