/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.packets.particle.curiosities.rite.InfernalExtinguishRiteEffectPacket;
import com.sammy.malum.common.packets.particle.curiosities.rite.generic.BlockSparkleParticlePacket;
import com.sammy.malum.common.spiritrite.PotionRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.block.BlockTagRegistry;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class InfernalRiteType
extends TotemicRiteType {
    public InfernalRiteType() {
        super("infernal_rite", SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.INFERNAL_SPIRIT, SpiritTypeRegistry.INFERNAL_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new PotionRiteEffect((Class<? extends LivingEntity>)LivingEntity.class, (Supplier<MobEffect>)MobEffectRegistry.MINERS_RAGE);
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new PotionRiteEffect(LivingEntity.class, (Supplier)MobEffectRegistry.IFRITS_EMBRACE){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                super.doRiteEffect(totemBase, level);
                this.getNearbyBlocks(totemBase, BaseFireBlock.class).forEach(p -> {
                    BlockState state = totemBase.m_58904_().m_8055_(p);
                    if (!state.m_204336_(BlockTagRegistry.ENDLESS_FLAME)) {
                        level.m_5594_(null, p, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
                        PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(p)), (Object)new InfernalExtinguishRiteEffectPacket(SpiritTypeRegistry.INFERNAL_SPIRIT.getPrimaryColor(), (BlockPos)p));
                        PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(p)), (Object)new BlockSparkleParticlePacket(SpiritTypeRegistry.ARCANE_SPIRIT.getPrimaryColor(), (BlockPos)p));
                        totemBase.m_58904_().m_7471_(p, false);
                    }
                });
            }

            @Override
            public Predicate<LivingEntity> getEntityPredicate() {
                return super.getEntityPredicate().and(Entity::m_6060_);
            }
        };
    }
}

