/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.nitrate;

import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class EthericNitrateImpactParticleEffect
extends ParticleEffectType {
    public EthericNitrateImpactParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            int i;
            double posX = positionData.posX;
            double posY = positionData.posY;
            double posZ = positionData.posZ;
            Vec3 pos = new Vec3(posX, posY, posZ);
            Color primaryColor = colorData.getDefaultColorRecord().primaryColor();
            Color secondaryColor = colorData.getDefaultColorRecord().secondaryColor();
            ColorParticleData colorParticleData = ColorParticleData.create((Color)primaryColor, (Color)secondaryColor).setEasing(Easing.SINE_IN_OUT).setCoefficient(0.9f).build();
            for (i = 0; i < 16; ++i) {
                boolean star;
                float lifetimeMultiplier = RandomHelper.randomBetween((RandomSource)random, (float)2.0f, (float)2.5f);
                float gravityStrength = RandomHelper.randomBetween((RandomSource)random, (float)0.01f, (float)0.05f);
                double horizontalAngle = random.m_188500_() * Math.PI * 2.0;
                double x = Math.cos(horizontalAngle);
                double y = Mth.m_216267_((RandomSource)random, (float)-1.0f, (float)1.0f);
                double z = Math.sin(horizontalAngle);
                Vec3 direction = new Vec3(x, y, z);
                Vec3 motion = direction.m_82490_((double)RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f));
                Vec3 spawnPosition = pos.m_82549_(direction.m_82490_(0.25));
                Consumer<LodestoneWorldParticle> slowDown = p -> {
                    Vec3 velocity = p.getParticleSpeed().m_82490_((double)0.8f);
                    if (velocity.equals((Object)Vec3.f_82478_)) {
                        velocity = p.getParticleSpeed();
                    }
                    p.m_172260_(velocity.f_82479_, (velocity.f_82480_ - (double)gravityStrength) * (double)0.98f, velocity.f_82481_);
                };
                boolean bl = star = random.m_188501_() < 0.2f;
                if (random.m_188501_() < 0.8f) {
                    ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spawnPosition, colorParticleData, new WorldParticleOptions(star ? (ParticleType)ParticleRegistry.STAR.get() : (ParticleType)ParticleRegistry.LIGHT_SPEC_SMALL.get()));
                    lightSpecs.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().addTickActor(slowDown).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).setMotion(motion);
                    lightSpecs.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).addTickActor(slowDown).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(star ? 3.0f : 2.0f)).setMotion(motion);
                    lightSpecs.spawnParticles();
                }
                if (star || !(random.m_188501_() < 0.8f)) continue;
                float scalar = RandomHelper.randomBetween((RandomSource)random, (float)0.8f, (float)1.1f);
                GenericParticleData lengthData = GenericParticleData.create((float)(2.0f * scalar), (float)(0.5f * scalar), (float)0.0f).setEasing(Easing.QUARTIC_OUT, Easing.SINE_IN_OUT).build();
                ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, spawnPosition, colorParticleData).act(b -> b.getParticleOptions().setBehavior((LodestoneBehaviorComponent)new SparkBehaviorComponent(lengthData)));
                sparks.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().addTickActor(slowDown).setMotion(motion).setScaleData(GenericParticleData.create((float)(0.4f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN, Easing.QUAD_IN).build());
                sparks.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).addTickActor(slowDown).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).setMotion(motion);
                sparks.spawnParticles();
            }
            for (i = 0; i < 3; ++i) {
                SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.m_216267_((RandomSource)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build();
                float scaleMultiplier = (float)(1.0 + Math.pow(random.m_188501_(), 2.0) * 0.5);
                WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.35f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setLifetime(15).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(1.6f * scaleMultiplier), (float)0.5f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN).build()).setColorData(colorParticleData).setRandomOffset((double)0.6f).enableNoClip().setRandomMotion((double)0.02f, (double)0.02f).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).repeat(level, posX, posY, posZ, 5);
            }
        };
    }
}

