/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.DumpLootModifiers;
import slimeknights.mantle.command.DumpTagCommand;
import slimeknights.mantle.command.HarvestTiersCommand;
import slimeknights.mantle.command.RegistryArgument;
import slimeknights.mantle.command.RemoveDataCommand;
import slimeknights.mantle.command.RemoveRecipesCommand;
import slimeknights.mantle.command.SourcesCommand;
import slimeknights.mantle.command.TagPreferenceCommand;
import slimeknights.mantle.command.TagsForCommand;
import slimeknights.mantle.command.ViewTagCommand;
import slimeknights.mantle.command.argument.TagSourceArgument;
import slimeknights.mantle.command.tags.ModifyTagCommand;

public class MantleCommand {
    public static final int PERMISSION_EDIT_SPAWN = 1;
    public static final int PERMISSION_GAME_COMMANDS = 2;
    public static final int PERMISSION_PLAYER_COMMANDS = 3;
    public static final int PERMISSION_OWNER = 4;
    @Deprecated(forRemoval=true)
    public static SuggestionProvider<CommandSourceStack> VALID_TAGS;
    @Deprecated(forRemoval=true)
    public static SuggestionProvider<CommandSourceStack> REGISTRY_VALUES;
    @Deprecated(forRemoval=true)
    public static SuggestionProvider<CommandSourceStack> REGISTRY;

    public static void init() {
        RegistryArgument.registerSuggestions();
        VALID_TAGS = RegistryArgument.TAG;
        REGISTRY_VALUES = RegistryArgument.VALUE;
        REGISTRY = RegistryArgument.REGISTRY;
        TagSourceArgument.registerSuggestions();
        SourcesCommand.register(LootDataType.f_278413_.m_278624_(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(context, builder) -> SharedSuggestionProvider.m_82926_((Iterable)((CommandSourceStack)context.getSource()).m_81377_().m_278653_().m_278706_(LootDataType.f_278413_), (SuggestionsBuilder)builder)));
        SourcesCommand.register("recipes", (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(context, builder) -> SharedSuggestionProvider.m_82957_((Stream)((CommandSourceStack)context.getSource()).m_6860_(), (SuggestionsBuilder)builder)));
        MinecraftForge.EVENT_BUS.addListener(MantleCommand::registerCommand);
    }

    private static void register(LiteralArgumentBuilder<CommandSourceStack> root, String name, Consumer<LiteralArgumentBuilder<CommandSourceStack>> consumer) {
        LiteralArgumentBuilder subCommand = Commands.m_82127_((String)name);
        consumer.accept((LiteralArgumentBuilder<CommandSourceStack>)subCommand);
        root.then((ArgumentBuilder)subCommand);
    }

    private static void registerCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"mantle");
        CommandBuildContext context = event.getBuildContext();
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "tags", b -> {
            MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "view", ViewTagCommand::register);
            MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "entries", DumpTagCommand::register);
            MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "dump", DumpAllTagsCommand::register);
            MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "for", TagsForCommand::register);
            MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "preference", TagPreferenceCommand::register);
            ModifyTagCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b);
        });
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "dump_loot_modifiers", DumpLootModifiers::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "harvest_tiers", HarvestTiersCommand::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "remove", b -> {
            b = (LiteralArgumentBuilder)b.requires(sender -> sender.m_6761_(2));
            MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "recipes", b2 -> RemoveRecipesCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b2, context));
            RemoveDataCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b);
        });
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "sources", b -> MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "data", SourcesCommand::register));
        event.getDispatcher().register(builder);
    }

    public static boolean requiresDebugInfoOrOp(CommandSourceStack source, int reducedDebugLevel) {
        return !source.m_81372_().m_46469_().m_46207_(GameRules.f_46145_) || source.m_6761_(reducedDebugLevel);
    }
}

