/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import slimeknights.mantle.Mantle;

public class SourcesCommand {
    private static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(id -> Mantle.makeComponent("command", "sources.not_found", id));
    private static final List<SourceFolder> FOLDERS = new ArrayList<SourceFolder>();

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        subCommand = (LiteralArgumentBuilder)subCommand.requires(source -> source.m_6761_(1));
        subCommand.then(Commands.m_82127_((String)"path").then(Commands.m_82129_((String)"path", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> SourcesCommand.run((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81377_().m_177941_(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"path")))));
        for (SourceFolder source2 : FOLDERS) {
            subCommand.then(Commands.m_82127_((String)source2.argument).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(source2.suggestionProvider).executes(context -> SourcesCommand.run((CommandContext<CommandSourceStack>)context, source.folder, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"id"), source.extension))));
        }
    }

    private static int run(CommandContext<CommandSourceStack> context, String folder, ResourceLocation id, String extension) throws CommandSyntaxException {
        return SourcesCommand.run(context, ((CommandSourceStack)context.getSource()).m_81377_().m_177941_(), id.m_247449_(folder + "/" + id.m_135815_() + extension));
    }

    public static int run(CommandContext<CommandSourceStack> context, ResourceManager manager, String folder, ResourceLocation id, String extension) throws CommandSyntaxException {
        return SourcesCommand.run(context, manager, id.m_247449_(folder + "/" + id.m_135815_() + extension));
    }

    public static int run(CommandContext<CommandSourceStack> context, ResourceManager manager, ResourceLocation path) throws CommandSyntaxException {
        List<String> packs = manager.m_213829_(path).stream().map(Resource::m_215506_).toList();
        if (packs.isEmpty()) {
            throw NOT_FOUND.create((Object)path);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> {
            MutableComponent component = Component.m_237110_((String)"command.mantle.sources.success", (Object[])new Object[]{path});
            for (String pack : packs) {
                component = component.m_7220_((Component)Component.m_237113_((String)("\n* " + (pack.isEmpty() ? "<unnamed>" : pack))));
            }
            return component;
        }, true);
        return packs.size();
    }

    public static SuggestionProvider<CommandSourceStack> suggestFolder(FileToIdConverter converter) {
        return (context, builder) -> SharedSuggestionProvider.m_82957_(converter.m_247457_(((CommandSourceStack)context.getSource()).m_81377_().m_177941_()).keySet().stream().map(arg_0 -> ((FileToIdConverter)converter).m_245273_(arg_0)), (SuggestionsBuilder)builder);
    }

    public static void register(String argument, String folder, String extension, SuggestionProvider<CommandSourceStack> suggestionProvider) {
        FOLDERS.add(new SourceFolder(argument, folder, extension, suggestionProvider));
    }

    public static void register(String folder, SuggestionProvider<CommandSourceStack> suggestionProvider) {
        SourcesCommand.register(folder, folder, ".json", suggestionProvider);
    }

    public record SourceFolder(String argument, String folder, String extension, SuggestionProvider<CommandSourceStack> suggestionProvider) {
    }
}

