/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless;

import dev.huskuraft.effortless.Effortless;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.platform.Mod;
import dev.huskuraft.effortless.api.platform.Platform;
import dev.huskuraft.effortless.api.platform.Server;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.networking.packets.session.SessionConfigPacket;
import dev.huskuraft.effortless.networking.packets.session.SessionPacket;
import dev.huskuraft.effortless.session.Session;
import dev.huskuraft.effortless.session.SessionManager;
import dev.huskuraft.effortless.session.config.SessionConfig;
import java.util.concurrent.atomic.AtomicReference;

public final class EffortlessSessionManager
implements SessionManager {
    private final Effortless entrance;
    private final AtomicReference<Session> serverSession = new AtomicReference();
    private final AtomicReference<Session> clientSession = new AtomicReference();

    public EffortlessSessionManager(Effortless entrance) {
        this.entrance = entrance;
        this.getEntrance().getEventRegistry().getPlayerChangeWorldEvent().register(this::onPlayerChangeWorld);
        this.getEntrance().getEventRegistry().getPlayerRespawnEvent().register(this::onPlayerRespawn);
        this.getEntrance().getEventRegistry().getPlayerLoggedInEvent().register(this::onPlayerLoggedIn);
        this.getEntrance().getEventRegistry().getPlayerLoggedOutEvent().register(this::onPlayerLoggedOut);
    }

    private Effortless getEntrance() {
        return this.entrance;
    }

    @Override
    public void onSession(Session session, Player player) {
        this.serverSession.set(session);
    }

    @Override
    public void onSessionConfig(SessionConfig sessionConfig, Player player) {
        if (!player.isOperator() && !player.isSinglePlayerOwner()) {
            player.sendMessage(Effortless.getSystemMessage(Text.text("You do not have permission to set server config.")));
            Effortless.LOGGER.warn("%s has no permission to set server config.".formatted(player.getProfile().getName()));
            return;
        }
        this.getEntrance().getSessionConfigStorage().set(sessionConfig);
        Server server = player.getServer();
        for (Player serverPlayer : server.getPlayerList().getPlayers()) {
            this.updateSessionConfig(serverPlayer);
        }
    }

    @Override
    public boolean isSessionValid() {
        return this.serverSession.get() != null;
    }

    @Override
    public SessionManager.SessionStatus getSessionStatus() {
        if (this.serverSession.get() == null && this.clientSession.get() == null) {
            return SessionManager.SessionStatus.MOD_MISSING;
        }
        if (this.serverSession.get() == null) {
            return SessionManager.SessionStatus.SERVER_MOD_MISSING;
        }
        if (this.clientSession.get() == null) {
            return SessionManager.SessionStatus.CLIENT_MOD_MISSING;
        }
        Mod serverMod = this.serverSession.get().mods().stream().filter(mod -> mod.getId().equals("effortless")).findFirst().orElseThrow();
        Mod clientMod = this.clientSession.get().mods().stream().filter(mod -> mod.getId().equals("effortless")).findFirst().orElseThrow();
        if (!serverMod.getVersionStr().equals(clientMod.getVersionStr())) {
            return SessionManager.SessionStatus.PROTOCOL_NOT_MATCH;
        }
        return SessionManager.SessionStatus.SUCCESS;
    }

    @Override
    public Session getLastSession() {
        Platform platform = Platform.getInstance();
        int protocolVersion = 13;
        return new Session(platform.getLoaderType(), platform.getLoaderVersion(), platform.getGameVersion(), platform.getRunningMods(), protocolVersion);
    }

    @Override
    public SessionConfig getLastSessionConfig() {
        return (SessionConfig)this.getEntrance().getSessionConfigStorage().get();
    }

    private void onPlayerChangeWorld(Player player, World origin, World destination) {
    }

    private void onPlayerRespawn(Player oldPlayer, Player newPlayer, boolean alive) {
    }

    private void onPlayerLoggedIn(Player player) {
        this.updateSession(player);
        this.updateSessionConfig(player);
    }

    private void onPlayerLoggedOut(Player player) {
    }

    private void updateSession(Player player) {
        this.getEntrance().getChannel().sendPacket(new SessionPacket(this.getLastSession()), player);
    }

    private void updateSessionConfig(Player player) {
        this.getEntrance().getChannel().sendPacket(new SessionConfigPacket(this.getLastSessionConfig()), player);
    }
}

