/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.clipboard;

import dev.huskuraft.effortless.building.Option;
import dev.huskuraft.effortless.building.clipboard.Snapshot;
import java.util.List;

public record Clipboard(boolean enabled, Snapshot snapshot) implements Option
{
    public static Clipboard DISABLED = new Clipboard(false, new Snapshot("", 0L, List.of()));

    public static Clipboard of(boolean enabled, Snapshot snapshot) {
        return new Clipboard(enabled, snapshot);
    }

    public Clipboard withEnabled(boolean enabled) {
        return new Clipboard(enabled, this.snapshot);
    }

    public Clipboard withSnapshot(Snapshot snapshot) {
        return new Clipboard(this.enabled, snapshot);
    }

    public Clipboard toggled() {
        return new Clipboard(!this.enabled, this.snapshot);
    }

    public boolean isEmpty() {
        return this.snapshot.isEmpty();
    }

    public boolean copyAir() {
        return false;
    }

    @Override
    public String getName() {
        if (this.enabled) {
            return "clipboard_enabled";
        }
        return "clipboard_disabled";
    }

    @Override
    public String getCategory() {
        return "clipboard";
    }
}

