/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.config;

import com.google.common.collect.Maps;
import dev.huskuraft.effortless.building.config.BuilderConfig;
import dev.huskuraft.effortless.building.config.ClipboardConfig;
import dev.huskuraft.effortless.building.config.PatternConfig;
import dev.huskuraft.effortless.building.config.RenderConfig;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public record ClientConfig(BuilderConfig builderConfig, RenderConfig renderConfig, PatternConfig patternConfig, ClipboardConfig clipboardConfig, Map<BuildMode, Structure> structureMap) {
    public static ClientConfig DEFAULT = new ClientConfig(BuilderConfig.DEFAULT, RenderConfig.DEFAULT, PatternConfig.DEFAULT, ClipboardConfig.DEFAULT, Arrays.stream(BuildMode.values()).collect(Collectors.toMap(Function.identity(), BuildMode::getDefaultStructure, (e1, e2) -> e1, LinkedHashMap::new)));

    public ClientConfig(RenderConfig renderConfig, PatternConfig patternConfig, ClipboardConfig clipboardConfig) {
        this(BuilderConfig.DEFAULT, renderConfig, patternConfig, clipboardConfig, DEFAULT.structureMap());
    }

    public ClientConfig withBuilderConfig(BuilderConfig builderConfig) {
        return new ClientConfig(builderConfig, this.renderConfig, this.patternConfig, this.clipboardConfig, this.structureMap);
    }

    public ClientConfig withRenderConfig(RenderConfig renderConfig) {
        return new ClientConfig(this.builderConfig, renderConfig, this.patternConfig, this.clipboardConfig, this.structureMap);
    }

    public ClientConfig withPatternConfig(PatternConfig patternConfig) {
        return new ClientConfig(this.builderConfig, this.renderConfig, patternConfig, this.clipboardConfig, this.structureMap);
    }

    public ClientConfig withClipboardConfig(ClipboardConfig clipboardConfig) {
        return new ClientConfig(this.builderConfig, this.renderConfig, this.patternConfig, clipboardConfig, this.structureMap);
    }

    public ClientConfig withPassiveMode(boolean passiveMode) {
        return new ClientConfig(this.builderConfig.withPassiveMode(passiveMode), this.renderConfig, this.patternConfig, this.clipboardConfig, this.structureMap);
    }

    public ClientConfig withStructure(Structure structure) {
        LinkedHashMap structureMap = Maps.newLinkedHashMap(this.structureMap);
        structureMap.put(structure.getMode(), structure);
        return new ClientConfig(this.builderConfig, this.renderConfig, this.patternConfig, this.clipboardConfig, Collections.unmodifiableMap(structureMap));
    }

    public Structure getStructure(BuildMode buildMode) {
        return this.structureMap.get((Object)buildMode);
    }
}

