/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.operation.batch;

import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.building.operation.ItemSummary;
import dev.huskuraft.effortless.building.operation.OperationResult;
import dev.huskuraft.effortless.building.operation.batch.BatchOperation;
import dev.huskuraft.effortless.building.operation.batch.DeferredBatchOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class BatchOperationResult
extends OperationResult {
    private final BatchOperation operation;
    private final Collection<? extends OperationResult> result;

    BatchOperationResult(BatchOperation operation, Collection<? extends OperationResult> result) {
        this.operation = operation;
        this.result = result;
    }

    private static <K> Map<K, Integer> merge(Map<K, Integer> a, Map<K, Integer> b) {
        return BatchOperationResult.merge(a, b, Integer::sum);
    }

    private static <K, V> Map<K, V> merge(Map<K, V> a, Map<K, V> b, BiFunction<V, V, V> merge) {
        for (Map.Entry entry : b.entrySet()) {
            a.compute(entry.getKey(), (k, v) -> v == null ? entry.getValue() : merge.apply(v, entry.getValue()));
        }
        return a;
    }

    @Override
    public BatchOperation getOperation() {
        return this.operation;
    }

    @Override
    public BatchOperation getReverseOperation() {
        return new DeferredBatchOperation(this.operation.getContext(), () -> this.result.stream().map(OperationResult::getReverseOperation));
    }

    @Override
    public int getAffectedBlockCount() {
        return this.getResults().stream().mapToInt(OperationResult::getAffectedBlockCount).sum();
    }

    public Collection<? extends OperationResult> getResults() {
        return this.result;
    }

    @Override
    public List<ItemStack> getItemSummary(ItemSummary itemSummary) {
        return this.result.stream().map(result -> result.getItemSummary(itemSummary)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

