/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern;

import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.BoundingBox3d;
import dev.huskuraft.effortless.api.math.Range1d;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.BuildStage;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.pattern.Transformers;
import dev.huskuraft.effortless.building.pattern.array.ArrayTransformer;
import dev.huskuraft.effortless.building.pattern.mirror.MirrorTransformer;
import dev.huskuraft.effortless.building.pattern.raidal.RadialTransformer;
import dev.huskuraft.effortless.building.pattern.randomize.ItemRandomizer;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Transformer {
    public static final Range1d POSITION_RANGE = new Range1d(-3.0E7, 3.0E7);
    public static final int MAX_NAME_LENGTH = 255;
    public static final BoundingBox3d POSITION_BOUND = BoundingBox3d.of(-2.147483648E9, -2.147483648E9, -2.147483648E9, 2.147483647E9, 2.147483647E9, 2.147483647E9);

    public static double roundHalf(double value) {
        return (double)Math.round(value * 2.0) / 2.0;
    }

    public static double floorHalf(double value) {
        return Math.floor(value) + 0.5;
    }

    public static double round(double value) {
        return Math.round(value);
    }

    public static Vector3d roundAllHalf(Vector3d vector3d) {
        if (Transformer.roundHalf(vector3d.x()) % 1.0 != 0.0 || Transformer.roundHalf(vector3d.y()) % 1.0 != 0.0 || Transformer.roundHalf(vector3d.z()) % 1.0 != 0.0) {
            return new Vector3d(Transformer.floorHalf(vector3d.x()), Transformer.floorHalf(vector3d.y()), Transformer.floorHalf(vector3d.z()));
        }
        return new Vector3d(Transformer.round(vector3d.x()), Transformer.round(vector3d.y()), Transformer.round(vector3d.z()));
    }

    public static boolean isCenter(Vector3d vector3d) {
        double x = Transformer.roundHalf(vector3d.x());
        double y = Transformer.roundHalf(vector3d.y());
        double z = Transformer.roundHalf(vector3d.z());
        return x % 1.0 != 0.0 || y % 1.0 != 0.0 || z % 1.0 != 0.0;
    }

    public static Vector3d roundHalf(Vector3d vector3d) {
        double x = Transformer.roundHalf(vector3d.x());
        double y = Transformer.roundHalf(vector3d.y());
        double z = Transformer.roundHalf(vector3d.z());
        if (x % 1.0 != 0.0 || y % 1.0 != 0.0 || z % 1.0 != 0.0) {
            return new Vector3d(Math.floor(vector3d.x()), Math.floor(vector3d.y()), Math.floor(vector3d.z()));
        }
        return new Vector3d(Transformer.floorHalf(vector3d.x()), Transformer.floorHalf(vector3d.y()), Transformer.floorHalf(vector3d.z()));
    }

    public static List<Transformer> getDefaultTransformers() {
        return Stream.of(List.of(ArrayTransformer.DEFAULT), List.of(MirrorTransformer.DEFAULT_X, MirrorTransformer.DEFAULT_Y, MirrorTransformer.DEFAULT_Z), List.of(RadialTransformer.DEFAULT), ItemRandomizer.getDefaultItemRandomizers()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public UUID id();

    public Text name();

    default public UUID getId() {
        return this.id();
    }

    public Text getName();

    public Operation transform(Operation var1);

    public Transformers getType();

    public Stream<Text> getSearchableTags();

    public boolean isValid();

    public Transformer withName(Text var1);

    public Transformer withId(UUID var1);

    public float volumeMultiplier();

    default public boolean isBuiltIn() {
        return !this.name().getString().isEmpty();
    }

    default public Transformer withRandomId() {
        return this.withId(UUID.randomUUID());
    }

    default public Transformer finalize(Player player, BuildStage stage) {
        return this;
    }

    default public List<Text> getDescriptions() {
        return List.of();
    }
}

