/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.PlaneFilling;
import dev.huskuraft.effortless.building.structure.PlaneLength;
import dev.huskuraft.effortless.building.structure.RaisedEdge;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.standard.DiagonalLine;
import dev.huskuraft.effortless.building.structure.builder.standard.Floor;
import dev.huskuraft.effortless.building.structure.builder.standard.Line;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;

public record SlopeFloor(PlaneLength planeLength, RaisedEdge raisedEdge) implements BlockStructure
{
    public SlopeFloor() {
        this(PlaneLength.VARIABLE, RaisedEdge.SHORT);
    }

    @Override
    public Structure withFeature(BuildFeature feature) {
        return switch (feature.getType()) {
            case BuildFeatures.PLANE_LENGTH -> new SlopeFloor((PlaneLength)feature, this.raisedEdge);
            case BuildFeatures.RAISED_EDGE -> new SlopeFloor(this.planeLength, (RaisedEdge)feature);
            default -> this;
        };
    }

    public static Stream<BlockPosition> collectSlopeFloorBlocks(Context context, RaisedEdge raisedEdge) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockPosition pos1 = context.getPosition(0);
        BlockPosition pos2 = context.getPosition(1);
        BlockPosition pos3 = context.getPosition(2);
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x2 = pos2.x();
        int y2 = pos2.y();
        int z2 = pos2.z();
        int x3 = pos3.x();
        int y3 = pos3.y();
        int z3 = pos3.z();
        int axisLimit = context.axisLimitation();
        int xLength = MathUtils.abs(x2 - x1);
        int zLength = MathUtils.abs(z2 - z1);
        Axis axis = switch (raisedEdge) {
            default -> throw new IncompatibleClassChangeError();
            case RaisedEdge.SHORT -> {
                if (zLength > xLength) {
                    yield Axis.Z;
                }
                yield Axis.X;
            }
            case RaisedEdge.LONG -> zLength > xLength ? Axis.X : Axis.Z;
        };
        switch (axis) {
            case X: {
                List<BlockPosition> line = DiagonalLine.collectDiagonalLine(new BlockPosition(x1, y1, z1), new BlockPosition(x2, y3, z1), 0, false).toList();
                int lowest = MathUtils.min(z1, z2);
                int highest = MathUtils.max(z1, z2);
                if (highest - lowest >= axisLimit) {
                    highest = lowest + axisLimit - 1;
                }
                for (int z = lowest; z <= highest; ++z) {
                    for (BlockPosition blockPosition : line) {
                        set.add(new BlockPosition(blockPosition.x(), blockPosition.y(), z));
                    }
                }
                break;
            }
            case Z: {
                List<BlockPosition> line = DiagonalLine.collectDiagonalLine(new BlockPosition(x1, y1, z1), new BlockPosition(x1, y3, z2), 0, false).toList();
                int lowest = MathUtils.min(x1, x2);
                int highest = MathUtils.max(x1, x2);
                if (highest - lowest >= axisLimit) {
                    highest = lowest + axisLimit - 1;
                }
                for (int x = lowest; x <= highest; ++x) {
                    for (BlockPosition blockPosition : line) {
                        set.add(new BlockPosition(x, blockPosition.y(), blockPosition.z()));
                    }
                }
                break;
            }
        }
        return set.stream();
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> Floor.traceFloor(player, context, this.planeLength);
            case 2 -> Line.traceLineY(player, context.getPosition(1));
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> Floor.collectFloorBlocks(context, PlaneFilling.FILLED);
            case 3 -> SlopeFloor.collectSlopeFloorBlocks(context, this.raisedEdge);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 3;
    }

    @Override
    public BuildMode getMode() {
        return BuildMode.SLOPE_FLOOR;
    }
}

