/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.transformer;

import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.input.NumberField;
import dev.huskuraft.effortless.api.gui.slot.ItemSlot;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.pattern.randomize.Chance;
import java.util.ArrayList;
import java.util.List;

public final class ItemChanceList
extends EditableEntryList<Chance<Item>> {
    public ItemChanceList(Entrance entrance, int x, int y, int width, int height) {
        super(entrance, x, y, width, height);
    }

    @Override
    protected EditableEntryList.Entry<Chance<Item>> createHolder(Chance<Item> item) {
        return new Entry((Entrance)this.getEntrance(), this, item);
    }

    public static class Entry
    extends EditableEntryList.Entry<Chance<Item>> {
        private ItemSlot itemSlot;
        private TextWidget nameTextWidget;
        private TextWidget chanceTextWidget;
        private NumberField numberField;

        public Entry(Entrance entrance, ItemChanceList itemChanceList, Chance<Item> chance) {
            super(entrance, itemChanceList, chance);
        }

        public static List<Text> getRandomizerEntryTooltip(Player player, Chance<Item> chance, int totalCount) {
            ArrayList<Text> components = new ArrayList<Text>(chance.content().getDefaultStack().getTooltips(player, ItemStack.TooltipType.ADVANCED_CREATIVE));
            String percentage = String.format("%.2f%%", 100.0 * (double)chance.chance() / (double)totalCount);
            components.add(Text.empty());
            components.add(Text.translate("effortless.transformer.randomizer.edit.total_probability", String.valueOf((Object)ChatFormatting.GOLD) + percentage + String.valueOf((Object)ChatFormatting.DARK_GRAY) + " (" + chance.chance() + "/" + totalCount + ")").withStyle(ChatFormatting.GRAY));
            return components;
        }

        public int totalCount() {
            return this.getEntryList().items().stream().mapToInt(Chance::chance).sum();
        }

        @Override
        public ItemChanceList getEntryList() {
            return (ItemChanceList)super.getEntryList();
        }

        @Override
        public List<Text> getTooltip() {
            if (this.getEntrance().getClient().getWindow().isAltDown()) {
                return Entry.getRandomizerEntryTooltip(this.getEntrance().getClient().getPlayer(), (Chance)this.getItem(), this.totalCount());
            }
            return super.getTooltip();
        }

        @Override
        public void onCreate() {
            this.numberField = this.addWidget(new NumberField((Entrance)this.getEntrance(), this.getX() + this.getWidth() - 48, this.getY() + 1, 48, 18, 0));
            this.numberField.setValueRange(0, 127);
            this.numberField.setValue(((Chance)this.getItem()).chance());
            this.numberField.setValueChangeListener(value -> this.setItem(Chance.of((Item)((Chance)this.getItem()).content(), value.intValue())));
            this.itemSlot = this.addWidget(new ItemSlot((Entrance)this.getEntrance(), this.getX() + 1, this.getY() + 1, 18, 18, (Item)((Chance)this.getItem()).content(), Text.text(String.valueOf(((Chance)this.getItem()).chance()))));
            this.chanceTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + this.getWidth() - 48 - 4, this.getY() + 6, Text.empty(), TextWidget.Gravity.END));
            this.nameTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + 24, this.getY() + 6, this.getDisplayName((Chance)this.getItem()), TextWidget.Gravity.START));
        }

        @Override
        public void onReload() {
            this.chanceTextWidget.setMessage(String.format("%.2f%%", 100.0 * (double)((Chance)this.getItem()).chance() / (double)this.totalCount()));
            this.itemSlot.setItemStack(((Item)((Chance)this.getItem()).content()).getDefaultStack());
            this.itemSlot.setDescription(Text.text(String.valueOf(((Chance)this.getItem()).chance())));
            this.nameTextWidget.setMessage(this.getDisplayName((Chance)this.getItem()));
            this.nameTextWidget.setWidth(this.getWidth() - 48 - 4 - 18 - 4 - this.chanceTextWidget.getWidth() - 8);
        }

        @Override
        public Text getNarration() {
            return Text.translate("narrator.select", this.getDisplayName((Chance)this.getItem()));
        }

        private Text getDisplayName(Chance<Item> chance) {
            return chance.content().getDefaultStack().getHoverName();
        }

        @Override
        public int getHeight() {
            return 24;
        }
    }
}

