/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.itemblacklist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import github.pitbox46.itemblacklist.blacklist.Blacklist;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();

    public static File initialize(Path folder, String fileName, RegistryAccess registryAccess) {
        File file = new File(folder.toFile(), fileName);
        try {
            if (file.createNewFile()) {
                Path defaultConfigPath = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("itemblacklist.json");
                if (Files.exists(defaultConfigPath, new LinkOption[0])) {
                    Files.copy(defaultConfigPath, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    FileWriter configWriter = new FileWriter(file);
                    Blacklist emptyBlacklist = Blacklist.emptyBlacklist();
                    configWriter.write(GSON.toJson(emptyBlacklist.encodeToJSON((HolderLookup.Provider)registryAccess)));
                    configWriter.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
        return file;
    }

    public static Blacklist readFromJson(File jsonFile, RegistryAccess registryAccess) {
        try {
            FileReader reader = new FileReader(jsonFile);
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            return Blacklist.readBlacklist((HolderLookup.Provider)registryAccess, json);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public static void writeJson(File jsonFile, Blacklist blacklist, RegistryAccess registryAccess) {
        try (FileReader reader = new FileReader(jsonFile);
             FileWriter fileWriter = new FileWriter(jsonFile);){
            fileWriter.write(GSON.toJson(blacklist.encodeToJSON((HolderLookup.Provider)registryAccess)));
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }
}

