/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.element;

import guideme.compiler.PageCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.scene.GuidebookScene;
import guideme.scene.element.SceneElementTagCompiler;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityElementCompiler
implements SceneElementTagCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(EntityElementCompiler.class);

    @Override
    public Set<String> getTagNames() {
        return Set.of("Entity");
    }

    @Override
    public void compile(GuidebookScene scene, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        String entityId = MdxAttrs.getString(compiler, errorSink, el, "id", null);
        if (entityId == null) {
            errorSink.appendError(compiler, "Missing attribute 'id'", el);
            return;
        }
        CompoundTag data = MdxAttrs.getCompoundTag(compiler, errorSink, el, "data", new CompoundTag());
        data.m_128359_("id", entityId);
        Entity entity = EntityType.m_20645_((CompoundTag)data, (Level)scene.getLevel(), Function.identity());
        if (entity == null) {
            errorSink.appendError(compiler, "Failed to load entity '" + entityId, el);
            return;
        }
        Vector3f pos = new Vector3f(0.5f, 0.0f, 0.5f);
        MdxAttrs.getFloatPos(compiler, errorSink, el, pos);
        entity.m_6034_((double)pos.x, (double)pos.y, (double)pos.z);
        float rotationY = MdxAttrs.getFloat(compiler, errorSink, el, "rotationY", -90.0f);
        float rotationX = MdxAttrs.getFloat(compiler, errorSink, el, "rotationX", 0.0f);
        entity.m_146922_(rotationY);
        entity.m_146926_(rotationX);
        entity.m_146867_();
        entity.m_5616_(entity.m_146908_());
        entity.m_5618_(entity.m_146908_());
        scene.getLevel().addEntity(entity);
        entity.m_8119_();
    }
}

