/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.client;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ClientTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.DialingDeviceTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.modules.teleporter.data.TransmitterInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GuiDialingDevice
extends GenericGuiContainer<DialingDeviceTileEntity, GenericContainer> {
    public static final int DIALER_WIDTH = 256;
    public static final int DIALER_HEIGHT = 224;
    private static final ResourceLocation guielements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    private EnergyBar energyBar;
    private WidgetList transmitterList;
    private WidgetList receiverList;
    private Button dialButton;
    private Button dialOnceButton;
    private Button interruptButton;
    private ImageChoiceLabel favoriteButton;
    private Button statusButton;
    private Label statusLabel;
    private boolean analyzerAvailable = false;
    private boolean lastDialedTransmitter = false;
    private boolean lastCheckedReceiver = false;
    public static int fromServer_receiverStatus = -1;
    public static int fromServer_dialResult = -1;
    public static List<TeleportDestinationClientInfo> fromServer_receivers = null;
    public static List<TransmitterInfo> fromServer_transmitters = null;
    private List<TeleportDestinationClientInfo> receivers = null;
    private boolean receiversFiltered = false;
    private List<TransmitterInfo> transmitters = null;
    private int listDirty = 10;

    public GuiDialingDevice(DialingDeviceTileEntity dialingDeviceTileEntity, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)dialingDeviceTileEntity, (AbstractContainerMenu)container, inventory, ((BaseBlock)TeleporterModule.DIALING_DEVICE.get()).getManualEntry());
        this.f_97726_ = 256;
        this.f_97727_ = 224;
    }

    public static void setReceiverStatus(int receiverStatus) {
        fromServer_receiverStatus = receiverStatus;
    }

    public static void setDialResult(int dialResult) {
        fromServer_dialResult = dialResult;
    }

    public static void register() {
        GuiDialingDevice.register(TeleporterModule.CONTAINER_DIALING_DEVICE.get(), GuiDialingDevice::new);
    }

    public void m_7856_() {
        super.m_7856_();
        Minecraft mc = this.f_96541_;
        this.energyBar = ((EnergyBar)((EnergyBar)((EnergyBar)new EnergyBar().filledRectThickness(1)).horizontal().desiredWidth(80)).desiredHeight(12)).showText(false);
        Panel transmitterPanel = this.setupTransmitterPanel();
        Panel receiverPanel = this.setupReceiverPanel();
        this.dialButton = (Button)((Button)((Button)((Button)Widgets.button((String)"Dial").channel("dial")).tooltips(new String[]{"Start a connection between", "the selected transmitter", "and the selected receiver"})).desiredHeight(14)).desiredWidth(65);
        this.dialOnceButton = (Button)((Button)((Button)((Button)Widgets.button((String)"Dial once").channel("dialonce")).tooltips(new String[]{"Dial a connection for a", "single teleport"})).desiredHeight(14)).desiredWidth(65);
        this.interruptButton = (Button)((Button)((Button)((Button)Widgets.button((String)"Interrupt").channel("interrupt")).tooltips(new String[]{"Interrupt a connection", "for the selected transmitter"})).desiredHeight(14)).desiredWidth(65);
        this.favoriteButton = (ImageChoiceLabel)((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().channel("favorite")).desiredWidth(10)).desiredHeight(10);
        this.favoriteButton.choice("No", "Unfavorited receiver", guielements, 131, 19);
        this.favoriteButton.choice("Yes", "Favorited receiver", guielements, 115, 19);
        this.favoriteButton.setCurrentChoice(((DialingDeviceTileEntity)this.tileEntity).isShowOnlyFavorites() ? 1 : 0);
        Panel buttonPanel = (Panel)((Panel)Widgets.horizontal().children(new Widget[]{this.dialButton, this.dialOnceButton, this.interruptButton, this.favoriteButton})).desiredHeight(16);
        this.analyzerAvailable = DialingDeviceTileEntity.isDestinationAnalyzerAvailable((Level)mc.f_91073_, ((DialingDeviceTileEntity)this.tileEntity).m_58899_());
        this.statusButton = (Button)((Button)((Button)((Button)Widgets.button((String)"Check").channel("check")).desiredHeight(14)).desiredWidth(65)).enabled(this.analyzerAvailable);
        if (this.analyzerAvailable) {
            this.statusButton.tooltips(new String[]{"Check the status of", "the selected receiver"});
        } else {
            this.statusButton.tooltips(new String[]{"Check the status of", "the selected receiver", "(needs an adjacent analyzer!)"});
        }
        this.statusLabel = new Label();
        ((Label)((Label)this.statusLabel.desiredWidth(170)).desiredHeight(14)).filledRectThickness(1);
        Panel statusPanel = (Panel)((Panel)Widgets.horizontal().children(new Widget[]{this.statusButton, this.statusLabel})).desiredHeight(16);
        Panel toplevel = (Panel)((Panel)Widgets.vertical((int)3, (int)1).filledRectThickness(2)).children(new Widget[]{this.energyBar, transmitterPanel, receiverPanel, buttonPanel, statusPanel});
        toplevel.bounds(this.f_97735_, this.f_97736_, 256, 224);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.event("dial", (souce, params) -> this.dial(false));
        this.window.event("dialonce", (souce, params) -> this.dial(true));
        this.window.event("interrupt", (souce, params) -> this.interruptDial());
        this.window.event("favorite", (souce, params) -> this.changeShowFavorite());
        this.window.event("check", (souce, params) -> this.checkStatus());
        ClientTools.enableKeyboardRepeat();
        fromServer_receivers = null;
        fromServer_transmitters = null;
        this.listDirty = 0;
        this.clearSelectedStatus();
        this.requestReceivers();
        this.requestTransmitters();
    }

    private Panel setupReceiverPanel() {
        this.receiverList = ((WidgetList)((WidgetList)new WidgetList().name("receivers")).rowheight(14).desiredHeight(100)).propagateEventsToChildren(true).event((SelectionEvent)new DefaultSelectionEvent(){

            public void select(int index) {
                GuiDialingDevice.this.clearSelectedStatus();
            }

            public void doubleClick(int index) {
                GuiDialingDevice.this.hilightSelectedReceiver(index);
            }
        });
        Slider receiverSlider = ((Slider)((Slider)new Slider().desiredWidth(11)).desiredHeight(100)).vertical().scrollableName("receivers");
        return (Panel)((Panel)((Panel)Widgets.horizontal((int)3, (int)1).children(new Widget[]{this.receiverList, receiverSlider})).desiredHeight(106)).filledBackground(-6381922);
    }

    private Panel setupTransmitterPanel() {
        this.transmitterList = ((WidgetList)((WidgetList)new WidgetList().name("transmitters")).rowheight(18).desiredHeight(58)).event((SelectionEvent)new DefaultSelectionEvent(){

            public void select(int index) {
                GuiDialingDevice.this.clearSelectedStatus();
                GuiDialingDevice.this.selectReceiverFromTransmitter();
            }

            public void doubleClick(int index) {
                GuiDialingDevice.this.hilightSelectedTransmitter(index);
            }
        });
        Slider transmitterSlider = ((Slider)((Slider)new Slider().desiredWidth(11)).desiredHeight(58)).vertical().scrollableName("transmitters");
        return (Panel)((Panel)((Panel)Widgets.horizontal((int)3, (int)1).children(new Widget[]{this.transmitterList, transmitterSlider})).desiredHeight(64)).filledBackground(-6381922);
    }

    private void clearSelectedStatus() {
        this.lastDialedTransmitter = false;
        this.lastCheckedReceiver = false;
    }

    private void hilightSelectedTransmitter(int index) {
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(index);
        if (transmitterInfo == null) {
            return;
        }
        BlockPos c = transmitterInfo.getCoordinate();
        RFToolsBase.instance.clientInfo.hilightBlock(c, System.currentTimeMillis() + 5000L);
        this.f_96541_.f_91074_.m_6915_();
    }

    private void hilightSelectedReceiver(int index) {
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(index);
        if (destination == null || destination.getDimension() == null) {
            return;
        }
        BlockPos c = destination.getCoordinate();
        double distance = new Vec3((double)c.m_123341_(), (double)c.m_123342_(), (double)c.m_123343_()).m_82554_(this.f_96541_.f_91074_.m_20182_());
        if (!destination.getDimension().equals((Object)this.f_96541_.f_91073_.m_46472_()) || distance > 150.0) {
            Logging.warn((Player)this.f_96541_.f_91074_, (String)"Receiver is too far to hilight!");
            this.f_96541_.f_91074_.m_6915_();
            return;
        }
        RFToolsBase.instance.clientInfo.hilightBlock(c, System.currentTimeMillis() + 5000L);
        Logging.message((Player)this.f_96541_.f_91074_, (String)"The receiver is now highlighted");
        this.f_96541_.f_91074_.m_6915_();
    }

    private void setStatusError(String message) {
        this.statusLabel.text(message);
        this.statusLabel.color(-1);
        this.statusLabel.filledBackground(-65536, -7864320);
    }

    private void setStatusMessage(String message) {
        this.statusLabel.text(message);
        this.statusLabel.color(-16777216);
        this.statusLabel.filledBackground(-16711936, -16742400);
    }

    private void checkStatus() {
        int receiverSelected = this.receiverList.getSelected();
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(receiverSelected);
        if (destination == null || destination.getDimension() == null) {
            return;
        }
        BlockPos c = destination.getCoordinate();
        TypedMap params = TypedMap.builder().put(DialingDeviceTileEntity.PARAM_POS, (Object)c).put(DialingDeviceTileEntity.PARAM_DIMENSION, (Object)destination.getDimension().m_135782_().toString()).build();
        Networking.sendToServer((Object)PacketRequestDataFromServer.create((ResourceKey)((DialingDeviceTileEntity)this.tileEntity).getDimension(), (BlockPos)((DialingDeviceTileEntity)this.tileEntity).m_58899_(), (String)DialingDeviceTileEntity.CMD_CHECKSTATUS.name(), (TypedMap)params, (boolean)false));
        this.lastCheckedReceiver = true;
        this.listDirty = 0;
    }

    private void showStatus(int dialResult) {
        if ((dialResult & 8) != 0) {
            this.setStatusError("Dialing device power low!");
            return;
        }
        if ((dialResult & 0x10) != 0) {
            this.setStatusError("Matter receiver power low!");
            return;
        }
        if ((dialResult & 0x200) != 0) {
            this.setStatusError("Destination dimension power low!");
            return;
        }
        if ((dialResult & 0x20) != 0) {
            this.setStatusError("No access to transmitter!");
            return;
        }
        if ((dialResult & 0x40) != 0) {
            this.setStatusError("No access to receiver!");
            return;
        }
        if ((dialResult & 4) != 0) {
            this.setStatusError("Invalid destination!");
            return;
        }
        if ((dialResult & 0x100) != 0) {
            this.setStatusError("Invalid source!");
            return;
        }
        if ((dialResult & 1) != 0) {
            this.setStatusError("Receiver blocked!");
            return;
        }
        if ((dialResult & 2) != 0) {
            this.setStatusError("Transmitter blocked!");
            return;
        }
        if ((dialResult & 0x400) != 0) {
            this.setStatusError("Invalid transmitter!!");
            return;
        }
        if ((dialResult & 0x80) != 0) {
            this.setStatusMessage("Interrupted!");
            return;
        }
        this.setStatusMessage("Dial ok!");
    }

    private void selectReceiverFromTransmitter() {
        this.receiverList.selected(-1);
        TeleportDestination destination = this.getSelectedTransmitterDestination();
        if (destination == null || destination.getDimension() == null) {
            return;
        }
        int i = 0;
        for (TeleportDestination teleportDestination : this.receivers) {
            if (teleportDestination.getDimension() == destination.getDimension() && teleportDestination.getCoordinate().equals((Object)destination.getCoordinate())) {
                this.receiverList.selected(i);
                return;
            }
            ++i;
        }
    }

    private void dial(boolean once) {
        int transmitterSelected = this.transmitterList.getSelected();
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return;
        }
        int receiverSelected = this.receiverList.getSelected();
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(receiverSelected);
        if (destination == null || destination.getDimension() == null) {
            return;
        }
        ResultCommand<?> command = once ? DialingDeviceTileEntity.CMD_DIALONCE : DialingDeviceTileEntity.CMD_DIAL;
        TypedMap params = TypedMap.builder().put(DialingDeviceTileEntity.PARAM_PLAYER_UUID, (Object)this.f_96541_.f_91074_.m_20148_()).put(DialingDeviceTileEntity.PARAM_TRANSMITTER, (Object)transmitterInfo.getCoordinate()).put(DialingDeviceTileEntity.PARAM_TRANS_DIMENSION, (Object)this.f_96541_.f_91073_.m_46472_().m_135782_().toString()).put(DialingDeviceTileEntity.PARAM_POS, (Object)destination.getCoordinate()).put(DialingDeviceTileEntity.PARAM_DIMENSION, (Object)destination.getDimension().m_135782_().toString()).build();
        Networking.sendToServer((Object)PacketRequestDataFromServer.create((ResourceKey)((DialingDeviceTileEntity)this.tileEntity).getDimension(), (BlockPos)((DialingDeviceTileEntity)this.tileEntity).m_58899_(), (String)command.name(), (TypedMap)params, (boolean)false));
        this.lastDialedTransmitter = true;
        this.listDirty = 0;
    }

    private TeleportDestinationClientInfo getSelectedReceiver(int receiverSelected) {
        if (receiverSelected == -1) {
            return null;
        }
        if (receiverSelected >= this.receivers.size()) {
            return null;
        }
        return this.receivers.get(receiverSelected);
    }

    private void interruptDial() {
        int transmitterSelected = this.transmitterList.getSelected();
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return;
        }
        TypedMap params = TypedMap.builder().put(DialingDeviceTileEntity.PARAM_PLAYER_UUID, (Object)this.f_96541_.f_91074_.m_20148_()).put(DialingDeviceTileEntity.PARAM_TRANSMITTER, (Object)transmitterInfo.getCoordinate()).put(DialingDeviceTileEntity.PARAM_TRANS_DIMENSION, (Object)this.f_96541_.f_91073_.m_46472_().m_135782_().toString()).put(DialingDeviceTileEntity.PARAM_POS, null).put(DialingDeviceTileEntity.PARAM_DIMENSION, (Object)Level.f_46428_.m_135782_().toString()).build();
        Networking.sendToServer((Object)PacketRequestDataFromServer.create((ResourceKey)((DialingDeviceTileEntity)this.tileEntity).getDimension(), (BlockPos)((DialingDeviceTileEntity)this.tileEntity).m_58899_(), (String)DialingDeviceTileEntity.CMD_DIAL.name(), (TypedMap)params, (boolean)false));
        this.lastDialedTransmitter = true;
        this.listDirty = 0;
    }

    private void requestReceivers() {
        TypedMap params = TypedMap.builder().put(DialingDeviceTileEntity.PARAM_PLAYER_UUID, (Object)this.f_96541_.f_91074_.m_20148_()).build();
        Networking.sendToServer((Object)PacketGetListFromServer.create((BlockPos)((DialingDeviceTileEntity)this.tileEntity).m_58899_(), (String)DialingDeviceTileEntity.CMD_GETRECEIVERS.name(), (TypedMap)params));
    }

    private void requestTransmitters() {
        Networking.sendToServer((Object)PacketGetListFromServer.create((BlockPos)((DialingDeviceTileEntity)this.tileEntity).m_58899_(), (String)DialingDeviceTileEntity.CMD_GETTRANSMITTERS.name()));
    }

    private void changeShowFavorite() {
        boolean fav = this.favoriteButton.getCurrentChoiceIndex() == 1;
        this.sendServerCommandTyped(DialingDeviceTileEntity.CMD_SHOWFAVORITE, TypedMap.builder().put(DialingDeviceTileEntity.PARAM_FAVORITE, (Object)fav).build());
        this.listDirty = 0;
        this.transmitterList.selected(-1);
        this.receiverList.selected(-1);
    }

    private void changeFavorite() {
        int receiverSelected = this.receiverList.getSelected();
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(receiverSelected);
        if (destination == null || destination.getDimension() == null) {
            return;
        }
        boolean favorite = destination.isFavorite();
        destination.setFavorite(!favorite);
        this.sendServerCommandTyped(DialingDeviceTileEntity.CMD_FAVORITE, TypedMap.builder().put(DialingDeviceTileEntity.PARAM_PLAYER, (Object)this.f_96541_.f_91074_.m_7755_().getString()).put(DialingDeviceTileEntity.PARAM_POS, (Object)destination.getCoordinate()).put(DialingDeviceTileEntity.PARAM_DIMENSION, (Object)destination.getDimension().m_135782_().toString()).put(DialingDeviceTileEntity.PARAM_FAVORITE, (Object)(!favorite ? 1 : 0)).build());
        this.listDirty = 0;
    }

    private void populateReceivers() {
        boolean newReceiversFiltered;
        List<TeleportDestinationClientInfo> newReceivers = fromServer_receivers;
        if (newReceivers == null) {
            return;
        }
        boolean bl = newReceiversFiltered = this.favoriteButton.getCurrentChoiceIndex() == 1;
        if (newReceivers.equals(this.receivers) && newReceiversFiltered == this.receiversFiltered) {
            return;
        }
        this.receiversFiltered = newReceiversFiltered;
        if (this.receiversFiltered) {
            this.receivers = new ArrayList<TeleportDestinationClientInfo>();
            for (TeleportDestinationClientInfo receiver : newReceivers) {
                if (!receiver.isFavorite()) continue;
                this.receivers.add(receiver);
            }
        } else {
            this.receivers = new ArrayList<TeleportDestinationClientInfo>(newReceivers);
        }
        this.receiverList.removeChildren();
        for (TeleportDestinationClientInfo destination : this.receivers) {
            BlockPos coordinate = destination.getCoordinate();
            Object dimName = destination.getDimensionName();
            if (dimName == null || ((String)dimName).trim().isEmpty()) {
                dimName = "Id " + destination.getDimension();
            }
            boolean favorite = destination.isFavorite();
            Panel panel = Widgets.horizontal((int)3, (int)1);
            panel.children(new Widget[]{((Label)((Label)((Label)Widgets.label((String)destination.getName()).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(96)).tooltips(new String[]{"The name of the", "destination receiver:", destination.getName() + " (" + BlockPosTools.toString((BlockPos)coordinate) + ")"})});
            panel.children(new Widget[]{((Label)((Label)((Label)((Label)Widgets.label((String)dimName).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).dynamic(true)).tooltips(new String[]{"The name of the", "destination dimension:", dimName})).desiredWidth(110)});
            ImageChoiceLabel choiceLabel = (ImageChoiceLabel)new ImageChoiceLabel().event(newChoice -> this.changeFavorite()).desiredWidth(10);
            choiceLabel.choice("No", "Not favorited", guielements, 131, 19);
            choiceLabel.choice("Yes", "Favorited", guielements, 115, 19);
            choiceLabel.setCurrentChoice(favorite ? 1 : 0);
            panel.children(new Widget[]{choiceLabel});
            this.receiverList.children(new Widget[]{panel});
        }
    }

    private TeleportDestination getSelectedTransmitterDestination() {
        int transmitterSelected = this.transmitterList.getSelected();
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return null;
        }
        TeleportDestination destination = transmitterInfo.getTeleportDestination();
        if (destination.isValid()) {
            return destination;
        }
        return null;
    }

    private void populateTransmitters() {
        List<TransmitterInfo> newTransmitters = fromServer_transmitters;
        if (newTransmitters == null) {
            return;
        }
        if (newTransmitters.equals(this.transmitters)) {
            return;
        }
        this.transmitters = new ArrayList<TransmitterInfo>(newTransmitters);
        this.transmitterList.removeChildren();
        for (TransmitterInfo transmitterInfo : this.transmitters) {
            BlockPos coordinate = transmitterInfo.getCoordinate();
            TeleportDestination destination = transmitterInfo.getTeleportDestination();
            Panel panel = (Panel)Widgets.horizontal((int)3, (int)5).children(new Widget[]{((Label)((Label)Widgets.label((String)transmitterInfo.getName()).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(102), ((Label)((Label)Widgets.label((String)BlockPosTools.toString((BlockPos)coordinate)).color(StyleConfig.colorTextInListNormal)).dynamic(true)).desiredWidth(90), ((ImageLabel)new ImageLabel().image(guielements, destination.isValid() ? 80 : 96, 0)).desiredWidth(16)});
            this.transmitterList.children(new Widget[]{panel});
        }
        if (this.transmitterList.getChildCount() == 1) {
            this.transmitterList.selected(0);
        }
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populateReceivers();
        this.populateTransmitters();
        if (this.lastDialedTransmitter) {
            this.showStatus(fromServer_dialResult);
        } else if (this.lastCheckedReceiver) {
            this.showStatus(fromServer_receiverStatus);
        } else {
            this.statusLabel.text("");
            this.statusLabel.color(-16777216);
            this.statusLabel.filledBackground(-1);
        }
        this.enableButtons();
        this.drawWindow(graphics);
        this.updateEnergyBar(this.energyBar);
    }

    private void requestListsIfNeeded() {
        if (fromServer_receivers != null && fromServer_transmitters != null) {
            return;
        }
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestReceivers();
            this.requestTransmitters();
            this.listDirty = 10;
        }
    }

    private String calculateDistance(int transmitterSelected, int receiverSelected) {
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return "?";
        }
        TeleportDestinationClientInfo teleportDestination = this.getSelectedReceiver(receiverSelected);
        if (teleportDestination == null) {
            return "?";
        }
        return DialingDeviceTileEntity.calculateDistance((Level)this.f_96541_.f_91073_, transmitterInfo, teleportDestination);
    }

    private TransmitterInfo getSelectedTransmitter(int transmitterSelected) {
        if (transmitterSelected == -1) {
            return null;
        }
        if (transmitterSelected >= this.transmitters.size()) {
            return null;
        }
        return this.transmitters.get(transmitterSelected);
    }

    private void enableButtons() {
        int transmitterSelected = this.transmitterList.getSelected();
        if (this.transmitters == null || transmitterSelected >= this.transmitters.size()) {
            transmitterSelected = -1;
            this.transmitterList.selected(-1);
        }
        int receiverSelected = this.receiverList.getSelected();
        if (this.receivers == null || receiverSelected >= this.receivers.size()) {
            receiverSelected = -1;
            this.receiverList.selected(-1);
        }
        if (transmitterSelected != -1 && receiverSelected != -1) {
            this.dialButton.enabled(true);
            this.dialOnceButton.enabled(true);
            String distance = this.calculateDistance(transmitterSelected, receiverSelected);
            this.dialButton.tooltips(new String[]{"Start a connection between", "the selected transmitter", "and the selected receiver.", "Distance: " + distance});
            this.dialOnceButton.tooltips(new String[]{"Dial a connection for a", "single teleport.", "Distance: " + distance});
        } else {
            this.dialButton.enabled(false);
            this.dialOnceButton.enabled(false);
            this.dialButton.tooltips(new String[]{"Start a connection between", "the selected transmitter", "and the selected receiver"});
            this.dialOnceButton.tooltips(new String[]{"Dial a connection for a", "single teleport"});
        }
        if (transmitterSelected != -1) {
            TeleportDestination destination = this.getSelectedTransmitterDestination();
            this.interruptButton.enabled(destination != null);
        } else {
            this.interruptButton.enabled(false);
        }
        if (receiverSelected != -1) {
            this.statusButton.enabled(this.analyzerAvailable);
        } else {
            this.statusButton.enabled(false);
        }
    }
}

