/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.operation.block;

import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.Items;
import dev.huskuraft.effortless.api.core.StatTypes;
import dev.huskuraft.effortless.api.tag.RecordTag;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.Storage;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.block.BlockInteractOperationResult;
import dev.huskuraft.effortless.building.operation.block.BlockOperation;
import dev.huskuraft.effortless.building.operation.block.BlockOperationResultType;
import dev.huskuraft.effortless.building.operation.block.Extras;
import dev.huskuraft.effortless.building.operation.empty.EmptyOperation;
import dev.huskuraft.effortless.building.pattern.MirrorContext;
import dev.huskuraft.effortless.building.pattern.MoveContext;
import dev.huskuraft.effortless.building.pattern.RefactorContext;
import dev.huskuraft.effortless.building.pattern.RotateContext;
import dev.huskuraft.effortless.building.session.Session;

public class BlockInteractOperation
extends BlockOperation {
    public BlockInteractOperation(Session session, Context context, Storage storage, BlockInteraction interaction, Extras extras) {
        super(session, context, storage, interaction, extras);
    }

    protected BlockOperationResultType interactBlock() {
        if (!this.context.extras().dimensionId().equals(this.getWorld().getDimensionId().location())) {
            return BlockOperationResultType.FAIL_WORLD_INCORRECT_DIM;
        }
        if (this.getPlayer().getGameMode().isSpectator()) {
            return BlockOperationResultType.FAIL_PLAYER_GAME_MODE;
        }
        if (!this.isInBorderBound()) {
            return BlockOperationResultType.FAIL_WORLD_BORDER;
        }
        if (!this.isInHeightBound()) {
            return BlockOperationResultType.FAIL_WORLD_HEIGHT;
        }
        if (this.getBlockState() == null) {
            return BlockOperationResultType.FAIL_BLOCK_STATE_NULL;
        }
        if (!this.allowInteraction()) {
            return BlockOperationResultType.FAIL_INTERACT_NO_PERMISSION;
        }
        if (!this.context.configs().constraintConfig().allowInteractBlocks().booleanValue()) {
            return BlockOperationResultType.FAIL_INTERACT_NO_PERMISSION;
        }
        if (!this.getBlockState().isAir()) {
            if (!this.context.configs().constraintConfig().whitelistedItems().isEmpty() && !this.context.configs().constraintConfig().whitelistedItems().contains(this.getBlockState().getItem().getId())) {
                return BlockOperationResultType.FAIL_INTERACT_BLACKLISTED;
            }
            if (!this.context.configs().constraintConfig().blacklistedItems().isEmpty() && this.context.configs().constraintConfig().blacklistedItems().contains(this.getBlockState().getItem().getId())) {
                return BlockOperationResultType.FAIL_INTERACT_BLACKLISTED;
            }
        }
        ItemStack itemStackToUse = this.storage.search(this.getPlayer().getItemStack(this.getHand()).getItem()).orElse(Items.AIR.item().getDefaultStack());
        if (this.context.isPreviewType() || this.context.isBuildClientType()) {
            itemStackToUse.decrease(1);
            return BlockOperationResultType.CONSUME;
        }
        if (this.context.isBuildType()) {
            ItemStack itemStackBeforeInteract = this.getPlayer().getItemStack(this.getHand());
            if (itemStackToUse.isDamageableItem() && itemStackToUse.getDurabilityLeft() <= this.context.getReservedToolDurability()) {
                return BlockOperationResultType.FAIL_INTERACT_TOOL_INSUFFICIENT;
            }
            this.getPlayer().setItemStack(this.getHand(), itemStackToUse);
            boolean interacted = this.getBlockStateInWorld().use(this.getPlayer(), this.interaction).consumesAction();
            if (!interacted && (interacted = this.getPlayer().getItemStack(this.interaction.getHand()).getItem().useOnBlock(this.getPlayer(), this.interaction).consumesAction()) && !this.getWorld().isClient()) {
                this.getPlayer().awardStat(StatTypes.ITEM_USED.get(itemStackToUse.getItem()));
            }
            if (itemStackBeforeInteract.isEmpty()) {
                if (this.getPlayer().getItemStack(this.getHand()).equals(itemStackToUse)) {
                    this.getPlayer().setItemStack(this.getHand(), itemStackBeforeInteract);
                }
            } else {
                this.getPlayer().setItemStack(this.getHand(), itemStackBeforeInteract);
            }
            if (!interacted) {
                return BlockOperationResultType.FAIL_UNKNOWN;
            }
        }
        return BlockOperationResultType.SUCCESS;
    }

    @Override
    public BlockInteractOperationResult commit() {
        Extras entityExtrasBeforeOp = Extras.get(this.getPlayer());
        BlockState blockStateBeforeOp = this.getBlockStateInWorld();
        RecordTag entityTagBeforeOp = this.getEntityTagInWorld();
        Extras.set(this.getPlayer(), this.getExtras());
        BlockOperationResultType result = this.interactBlock();
        Extras.set(this.getPlayer(), entityExtrasBeforeOp);
        if (this.getContext().isBuildClientType() && this.getBlockPosition().toVector3d().distance(this.getPlayer().getEyePosition()) <= 32.0) {
            this.getPlayer().getClient().getParticleEngine().crack(this.getBlockPosition(), this.getInteraction().getDirection());
        }
        BlockState blockStateAfterOp = this.getBlockStateInWorld();
        RecordTag entityTagAfterOp = this.getEntityTagInWorld();
        return new BlockInteractOperationResult(this, result, blockStateBeforeOp, blockStateAfterOp, entityTagBeforeOp, entityTagAfterOp);
    }

    @Override
    public Operation move(MoveContext moveContext) {
        return new BlockInteractOperation(this.session, this.context, this.storage, moveContext.move(this.interaction), this.extras);
    }

    @Override
    public Operation mirror(MirrorContext mirrorContext) {
        if (!mirrorContext.isInBounds(this.getBlockPosition().getCenter())) {
            return new EmptyOperation(this.context);
        }
        return new BlockInteractOperation(this.session, this.context, this.storage, mirrorContext.mirror(this.interaction), mirrorContext.mirror(this.extras));
    }

    @Override
    public Operation rotate(RotateContext rotateContext) {
        if (!rotateContext.isInBounds(this.getBlockPosition().getCenter())) {
            return new EmptyOperation(this.context);
        }
        return new BlockInteractOperation(this.session, this.context, this.storage, rotateContext.rotate(this.interaction), rotateContext.rotate(this.extras));
    }

    @Override
    public Operation refactor(RefactorContext refactorContext) {
        return this;
    }

    @Override
    public BlockOperation.Type getType() {
        return BlockOperation.Type.INTERACT;
    }
}

