/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern.mirror;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.math.BoundingBox3d;
import dev.huskuraft.effortless.api.math.Range1i;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.batch.GroupOperation;
import dev.huskuraft.effortless.building.pattern.MirrorContext;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.Transformers;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;

public record MirrorTransformer(UUID id, Text name, Vector3d position, Axis axis, int size) implements Transformer
{
    public static final MirrorTransformer ZERO_X = new MirrorTransformer(Vector3d.ZERO, Axis.X);
    public static final MirrorTransformer ZERO_Y = new MirrorTransformer(Vector3d.ZERO, Axis.Y);
    public static final MirrorTransformer ZERO_Z = new MirrorTransformer(Vector3d.ZERO, Axis.Z);
    public static final MirrorTransformer DEFAULT_X = new MirrorTransformer(new Vector3d(0.0, 0.0, 0.0), Axis.X);
    public static final MirrorTransformer DEFAULT_Y = new MirrorTransformer(new Vector3d(0.0, 0.0, 0.0), Axis.Y);
    public static final MirrorTransformer DEFAULT_Z = new MirrorTransformer(new Vector3d(0.0, 0.0, 0.0), Axis.Z);
    public static final Range1i SIZE_RANGE = new Range1i(1, 1024);
    public static final int DEFAULT_SIZE = 16;

    public MirrorTransformer(Vector3d position, Axis axis) {
        this(UUID.randomUUID(), Text.empty(), position, axis, 16);
    }

    @Override
    public Operation transform(Operation operation) {
        return new GroupOperation(operation.getContext(), Stream.of((Operation)((Operation)operation.mirror(new MirrorContext(this.position, this.getPositionBoundingBox(), this.axis))).mirror(new MirrorContext(this.position, this.getPositionBoundingBox(), this.axis)), (Operation)operation.mirror(new MirrorContext(this.position, this.getPositionBoundingBox(), this.axis))));
    }

    @Override
    public Text getName() {
        if (!this.name().getString().isEmpty()) {
            return this.name();
        }
        return Text.translate("effortless.transformer.mirror.no_name");
    }

    @Override
    public Transformers getType() {
        return Transformers.MIRROR;
    }

    @Override
    public Stream<Text> getSearchableTags() {
        return Stream.of(this.getName(), Text.text(this.position.toString()), Text.text(String.valueOf((Object)this.axis)));
    }

    @Override
    public boolean isValid() {
        return POSITION_BOUND.containsIn(this.position) && SIZE_RANGE.contains(this.size);
    }

    @Override
    public MirrorTransformer withName(Text name) {
        return new MirrorTransformer(this.id, name, this.position, this.axis, this.size);
    }

    @Override
    public MirrorTransformer withId(UUID id) {
        return new MirrorTransformer(id, this.name, this.position, this.axis, this.size);
    }

    public double getPosition(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.position.x();
            case Axis.Y -> this.position.y();
            case Axis.Z -> this.position.z();
        };
    }

    public MirrorTransformer withPosition(Vector3d offset) {
        return new MirrorTransformer(this.id, this.name, offset, this.axis, this.size);
    }

    public MirrorTransformer withPositionX(double x) {
        return new MirrorTransformer(this.id, this.name, new Vector3d(x, this.position.y(), this.position.z()), this.axis, this.size);
    }

    public MirrorTransformer withPositionY(double y) {
        return new MirrorTransformer(this.id, this.name, new Vector3d(this.position.x(), y, this.position.z()), this.axis, this.size);
    }

    public MirrorTransformer withPositionZ(double z) {
        return new MirrorTransformer(this.id, this.name, new Vector3d(this.position.x(), this.position.y(), z), this.axis, this.size);
    }

    public MirrorTransformer withAxis(Axis axis) {
        return new MirrorTransformer(this.id, this.name, this.position, axis, this.size);
    }

    public MirrorTransformer withSize(int size) {
        return new MirrorTransformer(this.id, this.name, this.position, this.axis, size);
    }

    public BoundingBox3d getPositionBoundingBox() {
        return BoundingBox3d.of(this.position.sub(this.size, this.size, this.size), this.position.add(this.size, this.size, this.size));
    }

    @Override
    public float volumeMultiplier() {
        return 2.0f;
    }

    @Override
    public List<Text> getDescriptions() {
        return List.of(Text.text("Position " + this.position.x() + " " + this.position.y() + " " + this.position.z()), Text.text("Axis ").append(this.axis.getDisplayName()), Text.text("Size " + this.size));
    }
}

