/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.events;

import com.google.auto.service.AutoService;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.huskuraft.effortless.api.core.InteractionHand;
import dev.huskuraft.effortless.api.core.InteractionType;
import dev.huskuraft.effortless.api.events.impl.ClientEventRegistry;
import dev.huskuraft.effortless.api.events.lifecycle.ClientTick;
import dev.huskuraft.effortless.api.input.InputKey;
import dev.huskuraft.effortless.forge.core.MinecraftConvertor;
import dev.huskuraft.effortless.forge.networking.ForgeNetworking;
import dev.huskuraft.effortless.forge.platform.MinecraftClient;
import dev.huskuraft.effortless.forge.renderer.MinecraftRenderer;
import dev.huskuraft.effortless.forge.renderer.MinecraftShader;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@AutoService(value={ClientEventRegistry.class})
public class ForgeClientEventRegistry
extends ClientEventRegistry {
    public ForgeClientEventRegistry() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterKeyMappings);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onReloadShader);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        this.getClientStartEvent().invoker().onClientStart(new MinecraftClient(Minecraft.m_91087_()));
        this.getRegisterNetworkEvent().invoker().onRegisterNetwork(ForgeNetworking::register);
    }

    @SubscribeEvent
    public void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        this.getRegisterKeysEvent().invoker().onRegisterKeys(key -> event.register((KeyMapping)key.getKeyBinding().reference()));
    }

    @SubscribeEvent
    public void onReloadShader(RegisterShadersEvent event) {
        this.getRegisterShaderEvent().invoker().onRegisterShader((resource, format, consumer) -> {
            ShaderInstance minecraftShader = new ShaderInstance(event.getResourceProvider(), resource.getPath(), (VertexFormat)format.reference());
            event.registerShader(minecraftShader, shaderInstance -> consumer.accept(new MinecraftShader((ShaderInstance)shaderInstance)));
        });
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        MinecraftClient minecraftClient = new MinecraftClient(Minecraft.m_91087_());
        this.getClientTickEvent().invoker().onClientTick(minecraftClient, switch (event.phase) {
            default -> throw new IncompatibleClassChangeError();
            case TickEvent.Phase.START -> ClientTick.Phase.START;
            case TickEvent.Phase.END -> ClientTick.Phase.END;
        });
    }

    @SubscribeEvent
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        this.getRenderWorldEvent().invoker().onRenderWorld(new MinecraftRenderer(event.getPoseStack()), event.getPartialTick());
    }

    @SubscribeEvent
    public void onRenderGui(RenderGuiEvent event) {
        this.getRenderGuiEvent().invoker().onRenderGui(new MinecraftRenderer(event.getGuiGraphics().m_280168_()), event.getPartialTick());
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        this.getKeyInputEvent().invoker().onKeyInput(new InputKey(event.getKey(), event.getScanCode(), event.getAction(), event.getModifiers()));
    }

    @SubscribeEvent
    public void onInteractionInput(InputEvent.InteractionKeyMappingTriggered event) {
        InteractionType type = event.isAttack() ? InteractionType.ATTACK : (event.isUseItem() ? InteractionType.USE_ITEM : InteractionType.UNKNOWN);
        InteractionHand hand = MinecraftConvertor.fromPlatformInteractionHand(event.getHand());
        if (this.getInteractionInputEvent().invoker().onInteractionInput(type, hand).interruptsFurtherEvaluation()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }
}

