/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.pattern;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.gui.Typeface;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.platform.ClientEntrance;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.pattern.array.ArrayTransformer;
import dev.huskuraft.effortless.renderer.pattern.TransformerRenderer;

public class ArrayTransformerRenderer
extends TransformerRenderer {
    private final ArrayTransformer transformer;

    public ArrayTransformerRenderer(ClientEntrance entrance, ArrayTransformer transformer) {
        super(entrance);
        this.transformer = transformer;
    }

    @Override
    public void render(Renderer renderer, float deltaTick) {
        Context context = this.getEntrance().getStructureBuilder().getContextTraced(EffortlessClient.getInstance().getClientManager().getRunningClient().getPlayer());
        if (context.interactionsSize() == 0) {
            return;
        }
        Typeface typeface = EffortlessClient.getInstance().getClient().getTypeface();
        for (BlockInteraction result : context.interactions().results()) {
            if (result == null) break;
            Vector3d interactionPosition = result.getBlockPosition().getCenter();
            for (int i = 0; i < this.transformer.copyCount(); ++i) {
                Vector3d v1 = interactionPosition.add(this.transformer.offset().mul(i).toVector3d());
                Vector3d v2 = interactionPosition.add(this.transformer.offset().mul(i + 1).toVector3d());
                this.renderAACuboidLine(renderer, v1, v2, 0.03125f, 0xFFFFFF, true);
                Vector3d cam = renderer.getCamera().position();
                renderer.pushPose();
                Vector3d mid = v1.add(v2).div(2.0);
                renderer.translate(mid.sub(cam));
                renderer.pushPose();
                renderer.rotate(renderer.getCamera().rotation());
                renderer.scale(-0.025f, -0.025f, 0.025f);
                Text text = Text.text(this.transformer.offset().toString());
                renderer.renderText(typeface, text, -typeface.measureWidth(text) / 2, 0, -1, 0, false, false, 0xF000F0);
                renderer.popPose();
                renderer.popPose();
            }
        }
    }
}

