/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.customization.block.CheckedWaterloggedBlock;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public abstract class DisplayBlock
extends ModBlock
implements EntityBlock,
CheckedWaterloggedBlock {
    public DisplayBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (this.doesHitTop(pHit)) {
            return this.useTop(pState, pLevel, pPos, pPlayer, pHand, pHit);
        }
        return this.useSide(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    protected InteractionResult useSide(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        return InteractionResult.PASS;
    }

    protected InteractionResult useTop(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof Container)) {
            return InteractionResult.FAIL;
        }
        Container container = (Container)blockEntity;
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack held = pPlayer.m_21120_(pHand);
        if (held.m_41619_()) {
            this.grab(pState, pLevel, pPos, pPlayer);
            return InteractionResult.CONSUME;
        }
        this.insertItem(container, pPlayer.m_150110_().f_35937_ ? held.m_41777_() : held);
        return InteractionResult.CONSUME;
    }

    public void click(BlockState blockState, Level level, BlockPos pos, ServerPlayer player, BlockHitResult hit) {
        if (this.doesHitTop(hit)) {
            this.clickTop(blockState, level, pos, player, hit);
        } else {
            this.clickSide(blockState, level, pos, player, hit);
        }
    }

    protected void clickSide(BlockState blockState, Level level, BlockPos pos, ServerPlayer player, BlockHitResult hit) {
    }

    protected void clickTop(BlockState blockState, Level level, BlockPos pos, ServerPlayer player, BlockHitResult hit) {
        this.grab(blockState, level, pos, (Player)player);
    }

    public boolean insertItem(Container container, ItemStack itemStack) {
        if (!container.m_7013_(0, itemStack)) {
            return false;
        }
        ItemStack displayed = container.m_8020_(0);
        if (displayed.m_41619_() || ItemStack.m_150942_((ItemStack)displayed, (ItemStack)itemStack)) {
            int maxSize = Math.min(itemStack.m_41741_(), container.m_6893_());
            int transferAmount = Math.min(itemStack.m_41613_(), maxSize - displayed.m_41613_());
            if (transferAmount > 0) {
                ItemStack split = itemStack.m_41620_(transferAmount);
                split.m_41769_(displayed.m_41613_());
                container.m_6836_(0, split);
                return true;
            }
        }
        return false;
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        super.m_141947_(pLevel, pPos, pState, pEntity);
        if (!pLevel.f_46443_ && pEntity instanceof ItemEntity) {
            Container container;
            ItemEntity itemEntity = (ItemEntity)pEntity;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof Container && this.insertItem(container = (Container)blockEntity, itemEntity.m_32055_())) {
                itemEntity.m_32045_(itemEntity.m_32055_());
            }
        }
    }

    public void grab(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        BlockEntity blockEntity;
        if (pLevel.f_46443_ || !((blockEntity = pLevel.m_7702_(pPos)) instanceof Container)) {
            return;
        }
        Container be = (Container)blockEntity;
        ItemStack item = be.m_8020_(0);
        if (item.m_41619_()) {
            return;
        }
        be.m_6836_(0, ItemStack.f_41583_);
        double d3 = (double)pPos.m_123341_() + 0.5;
        double d4 = pPos.m_123342_() + 1;
        double d5 = (double)pPos.m_123343_() + 0.5;
        ItemEntity itementity = new ItemEntity(pLevel, d3, d4, d5, item);
        itementity.m_20334_(0.0, 0.2, 0.0);
        pLevel.m_7967_((Entity)itementity);
        itementity.m_6123_(pPlayer);
    }

    public boolean doesHitTop(BlockHitResult pHit) {
        return pHit.m_82434_() == Direction.UP && pHit.m_82450_().f_82480_ - (double)pHit.m_82425_().m_123342_() > 0.75;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity;
        if (pStack.m_41788_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity be = (BaseContainerBlockEntity)blockEntity;
            be.m_58638_(pStack.m_41786_());
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!pState.m_60713_(pNewState.m_60734_()) && (blockEntity = pLevel.m_7702_(pPos)) instanceof Container) {
            Container container = (Container)blockEntity;
            Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)container);
            pLevel.m_46717_(pPos, (Block)this);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)pLevel.m_7702_(pPos));
    }

    public boolean canBeDestroyed(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        Container container;
        BlockEntity blockEntity = level.m_7702_(pos);
        return !(blockEntity instanceof Container) || (container = (Container)blockEntity).m_7983_();
    }
}

