/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits;

import com.enderio.api.conduit.ConduitItemFactory;
import com.enderio.api.conduit.ConduitType;
import com.enderio.base.data.EIODataProvider;
import com.enderio.conduits.common.conduit.ConduitBlockItem;
import com.enderio.conduits.common.init.ConduitBlockEntities;
import com.enderio.conduits.common.init.ConduitBlocks;
import com.enderio.conduits.common.init.ConduitItems;
import com.enderio.conduits.common.init.ConduitLang;
import com.enderio.conduits.common.init.ConduitMenus;
import com.enderio.conduits.common.init.EIOConduitTypes;
import com.enderio.conduits.common.integrations.Integrations;
import com.enderio.conduits.common.network.ConduitNetwork;
import com.enderio.conduits.data.ConduitTagProvider;
import com.enderio.conduits.data.recipe.ConduitRecipes;
import com.enderio.conduits.data.recipe.RedstoneFilterRecipes;
import java.util.function.Supplier;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="enderio", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EIOConduits {
    @SubscribeEvent
    public static void onConstruct(FMLConstructModEvent event) {
        System.out.println("================ Conduits construct ==================");
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        EIOConduitTypes.register(bus);
        ConduitBlockEntities.register();
        ConduitMenus.register();
        ConduitBlocks.register();
        ConduitItems.register();
        Integrations.register();
        ConduitNetwork.register();
        ConduitLang.register();
        ConduitItemFactory.setFactory((type, properties) -> new ConduitBlockItem((Supplier<? extends ConduitType<?>>)type, (Block)ConduitBlocks.CONDUIT.get(), (Item.Properties)properties));
    }

    @SubscribeEvent
    public static void onData(GatherDataEvent event) {
        PackOutput packOutput = event.getGenerator().getPackOutput();
        EIODataProvider provider = new EIODataProvider("conduits");
        provider.addSubProvider(event.includeServer(), (DataProvider)new ConduitTagProvider(packOutput, event.getLookupProvider(), event.getExistingFileHelper()));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ConduitRecipes(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new RedstoneFilterRecipes(packOutput));
        event.getGenerator().addProvider(true, (DataProvider)provider);
    }
}

