/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.network;

import com.enderio.api.conduit.ConduitType;
import com.enderio.conduits.common.conduit.block.ConduitBlockEntity;
import com.enderio.conduits.common.conduit.connection.DynamicConnectionState;
import com.enderio.conduits.common.init.EIOConduitTypes;
import com.enderio.core.common.network.Packet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class C2SSetConduitConnectionState
implements Packet {
    private final BlockPos pos;
    private final Direction direction;
    private final ConduitType<?> conduitType;
    private final DynamicConnectionState connectionState;

    public C2SSetConduitConnectionState(BlockPos pos, Direction direction, ConduitType<?> conduitType, DynamicConnectionState connectionState) {
        this.pos = pos;
        this.direction = direction;
        this.conduitType = conduitType;
        this.connectionState = connectionState;
    }

    public C2SSetConduitConnectionState(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.direction = (Direction)buf.m_130066_(Direction.class);
        this.conduitType = (ConduitType)EIOConduitTypes.REGISTRY.get().getValue(buf.m_130281_());
        this.connectionState = DynamicConnectionState.fromNetwork(buf);
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getSender() != null && this.conduitType != null;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerLevel level = context.getSender().m_284548_();
        BlockEntity be = level.m_7702_(this.pos);
        if (be instanceof ConduitBlockEntity) {
            ConduitBlockEntity conduitBlockEntity = (ConduitBlockEntity)be;
            conduitBlockEntity.handleConnectionStateUpdate(this.direction, this.conduitType, this.connectionState);
        }
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_130064_(this.pos);
        writeInto.m_130068_((Enum)this.direction);
        writeInto.m_130085_(EIOConduitTypes.REGISTRY.get().getKey(this.conduitType));
        this.connectionState.toNetwork(writeInto);
    }

    public static class Handler
    extends Packet.PacketHandler<C2SSetConduitConnectionState> {
        @Override
        public C2SSetConduitConnectionState fromNetwork(FriendlyByteBuf buf) {
            return new C2SSetConduitConnectionState(buf);
        }

        @Override
        public void toNetwork(C2SSetConduitConnectionState packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_SERVER);
        }
    }
}

