/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.rendering.travel;

import com.enderio.api.travel.ITravelTarget;
import com.enderio.base.common.handler.TravelHandler;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.travel.AnchorTravelTarget;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class TravelAnchorHud
implements IGuiOverlay {
    public static final TravelAnchorHud INSTANCE = new TravelAnchorHud();
    static final int CURSOR_GAP = 20;
    static final int ITEM_TEXT_GAP = 6;
    static final int ITEM_SIZE = 16;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft minecraft = gui.getMinecraft();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || !TravelHandler.canBlockTeleport((Player)player)) {
            return;
        }
        TravelHandler.getElevatorAnchorTarget((Player)player, Direction.UP).ifPresent(target -> TravelAnchorHud.showElevatorTarget(guiGraphics, minecraft.f_91062_, screenWidth, screenHeight, target, Direction.UP));
        TravelHandler.getElevatorAnchorTarget((Player)player, Direction.DOWN).ifPresent(target -> TravelAnchorHud.showElevatorTarget(guiGraphics, minecraft.f_91062_, screenWidth, screenHeight, target, Direction.DOWN));
    }

    private static void showElevatorTarget(GuiGraphics guiGraphics, Font font, int screenWidth, int screenHeight, ITravelTarget target, Direction direction) {
        Object txt = switch (direction) {
            case Direction.UP -> "\u2191";
            case Direction.DOWN -> "\u2193";
            case Direction.EAST -> "\u2192";
            case Direction.WEST -> "\u2190";
            default -> "";
        };
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        if (target instanceof AnchorTravelTarget) {
            Item icon;
            AnchorTravelTarget anchorTarget = (AnchorTravelTarget)target;
            String anchorName = anchorTarget.getName();
            if (!anchorName.isEmpty()) {
                txt = anchorName + " " + (String)txt;
            }
            if ((icon = anchorTarget.getIcon()) == Blocks.f_50016_.m_5456_()) {
                icon = MachineBlocks.TRAVEL_ANCHOR.m_5456_();
            }
            ItemStack itemStack = icon.m_7968_();
            int x = centerX + TravelAnchorHud.getOffset(20, 16, direction.m_122429_());
            int y = centerY + TravelAnchorHud.getOffset(20, 16, -direction.m_122430_());
            guiGraphics.m_280480_(itemStack, x, y);
        }
        int textWidth = font.m_92895_((String)txt);
        int offsetAmount = 42;
        int textX = centerX + TravelAnchorHud.getOffset(offsetAmount, textWidth, direction.m_122429_());
        Objects.requireNonNull(font);
        int textY = centerY + TravelAnchorHud.getOffset(offsetAmount, 9, -direction.m_122430_());
        int bgFromX = textX - 2;
        int bgFromY = textY - 2;
        int bgToX = bgFromX + textWidth + 3;
        Objects.requireNonNull(font);
        int bgToY = bgFromY + 9 + 3;
        guiGraphics.m_280509_(bgFromX, bgFromY, bgToX, bgToY, -2030043136);
        guiGraphics.m_280056_(font, (String)txt, textX, textY, 0xFFFFFF, false);
    }

    private static int getOffset(int offsetAmount, int size, int direction) {
        return (offsetAmount + size / 2) * direction - size / 2;
    }
}

