/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.math.MatrixUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.apache.logging.log4j.LogManager;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import ttv.migami.jeg.client.handler.AimingHandler;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.item.TelescopicScopeItem;
import ttv.migami.jeg.item.attachment.IAttachment;

public class RenderUtil {
    private static final ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.m_245263_((String)"trident", (String)"inventory");
    private static final ModelResourceLocation SPYGLASS_MODEL = ModelResourceLocation.m_245263_((String)"spyglass", (String)"inventory");
    public static final float BEAM_ALPHA = 0.7f;

    public static void scissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        int scale = (int)mc.m_91268_().m_85449_();
        GL11.glScissor((int)(x * scale), (int)(mc.m_91268_().m_85444_() - y * scale - height * scale), (int)Math.max(0, width * scale), (int)Math.max(0, height * scale));
    }

    public static BakedModel getModel(Item item) {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(new ItemStack((ItemLike)item));
    }

    public static BakedModel getModel(ItemStack item) {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(item);
    }

    public static void rotateZ(PoseStack poseStack, float xOffset, float yOffset, float rotation) {
        poseStack.m_252880_(xOffset, yOffset, 0.0f);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(rotation));
        poseStack.m_252880_(-xOffset, -yOffset, 0.0f);
    }

    public static void renderGun(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, @Nullable LivingEntity entity) {
        RenderUtil.renderModel(stack, ItemDisplayContext.NONE, poseStack, buffer, light, overlay, entity);
    }

    public static void renderModel(ItemStack child, ItemStack parent, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(child);
        RenderUtil.renderModel(model, ItemDisplayContext.NONE, null, child, parent, poseStack, buffer, light, overlay);
    }

    public static void renderModel(ItemStack stack, ItemDisplayContext display, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, @Nullable LivingEntity entity) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(stack);
        if (entity != null) {
            model = Minecraft.m_91087_().m_91291_().m_174264_(stack, entity.m_9236_(), entity, 0);
        }
        RenderUtil.renderModel(model, display, stack, poseStack, buffer, light, overlay);
    }

    public static void renderModel(ItemStack stack, ItemDisplayContext display, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, @Nullable Level world, @Nullable LivingEntity entity) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, world, entity, 0);
        RenderUtil.renderModel(model, display, stack, poseStack, buffer, light, overlay);
    }

    public static void renderModel(BakedModel model, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(model, ItemDisplayContext.NONE, stack, poseStack, buffer, light, overlay);
    }

    public static void renderModel(BakedModel model, ItemDisplayContext display, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(model, display, null, stack, ItemStack.f_41583_, poseStack, buffer, light, overlay);
    }

    public static void renderModel(BakedModel model, ItemDisplayContext display, @Nullable Runnable transform, ItemStack stack, ItemStack parent, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (!stack.m_41619_()) {
            boolean flag;
            poseStack.m_85836_();
            boolean bl = flag = display == ItemDisplayContext.GUI || display == ItemDisplayContext.GROUND || display == ItemDisplayContext.FIXED;
            if (flag) {
                if (stack.m_150930_(Items.f_42713_)) {
                    model = Minecraft.m_91087_().m_91304_().m_119422_(TRIDENT_MODEL);
                } else if (stack.m_150930_(Items.f_151059_)) {
                    model = Minecraft.m_91087_().m_91304_().m_119422_(SPYGLASS_MODEL);
                }
            }
            model = model.applyTransform(display, poseStack, false);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            if (!model.m_7521_() && (stack.m_41720_() != Items.f_42713_ || flag)) {
                VertexConsumer builder;
                boolean entity = true;
                if (display != ItemDisplayContext.GUI && !display.m_269069_() && stack.m_41720_() instanceof BlockItem) {
                    Block block = ((BlockItem)stack.m_41720_()).m_40614_();
                    entity = !(block instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock);
                }
                RenderType renderType = RenderUtil.getRenderType(stack, entity);
                if (stack.m_41720_() == Items.f_42522_ && stack.m_41790_()) {
                    poseStack.m_85836_();
                    PoseStack.Pose entry = poseStack.m_85850_();
                    if (display == ItemDisplayContext.GUI) {
                        MatrixUtil.m_253023_((Matrix4f)entry.m_252922_(), (float)0.5f);
                    } else if (display.m_269069_()) {
                        MatrixUtil.m_253023_((Matrix4f)entry.m_252922_(), (float)0.75f);
                    }
                    builder = entity ? ItemRenderer.m_115207_((MultiBufferSource)buffer, (RenderType)renderType, (PoseStack.Pose)entry) : ItemRenderer.m_115180_((MultiBufferSource)buffer, (RenderType)renderType, (PoseStack.Pose)entry);
                    poseStack.m_85849_();
                } else {
                    builder = entity ? ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (stack.m_41790_() || parent.m_41790_() ? 1 : 0) != 0) : ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (stack.m_41790_() || parent.m_41790_() ? 1 : 0) != 0);
                }
                RenderUtil.renderModel(model, stack, parent, transform, poseStack, builder, light, overlay);
            } else {
                IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().m_108829_(stack, display, poseStack, buffer, light, overlay);
            }
            poseStack.m_85849_();
        }
    }

    public static void renderModelWithTransforms(ItemStack child, ItemStack parent, ItemDisplayContext display, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        poseStack.m_85836_();
        BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(child);
        model = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemDisplayContext)display, (boolean)false);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        RenderUtil.renderItemWithoutTransforms(model, child, parent, poseStack, buffer, light, overlay);
        poseStack.m_85849_();
    }

    public static void renderItemWithoutTransforms(BakedModel model, ItemStack stack, ItemStack parent, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        RenderType renderType = RenderUtil.getRenderType(stack, false);
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (stack.m_41790_() || parent.m_41790_() ? 1 : 0) != 0);
        RenderUtil.renderModel(model, stack, parent, null, poseStack, builder, light, overlay);
    }

    public static void renderItemWithoutTransforms(BakedModel model, ItemStack stack, ItemStack parent, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, @Nullable Runnable transform) {
        RenderType renderType = RenderUtil.getRenderType(stack, false);
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (stack.m_41790_() || parent.m_41790_() ? 1 : 0) != 0);
        RenderUtil.renderModel(model, stack, parent, transform, poseStack, builder, light, overlay);
    }

    public static void renderModel(BakedModel model, ItemStack stack, ItemStack parent, @Nullable Runnable transform, PoseStack poseStack, VertexConsumer buffer, int light, int overlay) {
        if (transform != null) {
            transform.run();
        }
        RandomSource random = RandomSource.m_216327_();
        for (Direction direction : Direction.values()) {
            random.m_188584_(42L);
            RenderUtil.renderQuads(poseStack, buffer, model.m_213637_(null, direction, random), stack, parent, light, overlay);
        }
        random.m_188584_(42L);
        RenderUtil.renderQuads(poseStack, buffer, model.m_213637_(null, null, random), stack, parent, light, overlay);
    }

    public static void renderMacerateWheel(BakedModel model, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (model == null) {
            LogManager.getLogger().warn("Tried to render a null model!");
            return;
        }
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110451_());
        Minecraft.m_91087_().m_91291_().m_115189_(model, ItemStack.f_41583_, light, overlay, poseStack, vertexConsumer);
    }

    private static void renderQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, ItemStack stack, ItemStack parent, int light, int overlay) {
        PoseStack.Pose entry = poseStack.m_85850_();
        for (BakedQuad quad : quads) {
            int color = -1;
            if (quad.m_111304_()) {
                color = RenderUtil.getItemStackColor(stack, parent, quad.m_111305_());
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            buffer.m_85987_(entry, quad, red, green, blue, light, overlay);
        }
    }

    public static int getItemStackColor(ItemStack stack, ItemStack parent, int tintIndex) {
        int color = Minecraft.m_91087_().getItemColors().m_92676_(stack, tintIndex);
        if (color == -1 && !parent.m_41619_()) {
            return RenderUtil.getItemStackColor(parent, ItemStack.f_41583_, tintIndex);
        }
        return color;
    }

    public static void applyTransformType(ItemStack stack, PoseStack poseStack, ItemDisplayContext display, @Nullable LivingEntity entity) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, entity != null ? entity.m_9236_() : null, entity, 0);
        boolean leftHanded = display == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || display == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        model = model.applyTransform(display, poseStack, leftHanded);
        if (leftHanded) {
            Matrix4f scale = new Matrix4f().scale(-1.0f, 1.0f, 1.0f);
            Matrix3f normal = new Matrix3f((Matrix4fc)scale);
            poseStack.m_85850_().m_252922_().mul((Matrix4fc)scale);
            poseStack.m_85850_().m_252943_().mul((Matrix3fc)normal);
        }
    }

    public static boolean isMouseWithin(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static void renderFirstPersonArm(LocalPlayer player, HumanoidArm hand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        ItemStack stack = player.m_21205_();
        if (AimingHandler.get().isAiming() && (Gun.getAttachment(IAttachment.Type.SCOPE, stack).m_41720_() instanceof TelescopicScopeItem || Gun.getAttachment(IAttachment.Type.SCOPE, stack).m_150930_(Items.f_151059_))) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher renderManager = mc.m_91290_();
        PlayerRenderer renderer = (PlayerRenderer)renderManager.m_114382_((Entity)player);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)player.m_108560_());
        if (hand == HumanoidArm.RIGHT) {
            renderer.m_117770_(poseStack, buffer, combinedLight, (AbstractClientPlayer)player);
        } else {
            renderer.m_117813_(poseStack, buffer, combinedLight, (AbstractClientPlayer)player);
        }
    }

    public static RenderType getRenderType(ItemStack stack, boolean entity) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            return ItemBlockRenderTypes.m_109284_((BlockState)block.m_49966_(), (!entity ? 1 : 0) != 0);
        }
        return RenderType.m_110473_((ResourceLocation)InventoryMenu.f_39692_);
    }

    public static void renderBeam(PoseStack poseStack, MultiBufferSource pBufferSource, ResourceLocation pBeamLocation, float pPartialTick, float pTextureScale, long gameTime, float pYOffset, float pHeight, int rgb, float alpha, float pBeamRadius, float pGlowRadius) {
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        float maxY = pYOffset + pHeight;
        poseStack.m_85836_();
        float f = (float)Math.floorMod(gameTime, 40) + pPartialTick;
        float f1 = pHeight < 0.0f ? f : -f;
        float f2 = Mth.m_14187_((float)(f1 * 0.2f - (float)Mth.m_14143_((float)(f1 * 0.1f))));
        poseStack.m_85836_();
        float minX = -pGlowRadius;
        float maxX = -pGlowRadius;
        float minZ = -pGlowRadius;
        float maxZ = -pBeamRadius;
        float f12 = -pBeamRadius;
        float v = -1.0f + f2;
        float u = pHeight * pTextureScale * (0.7f / pBeamRadius) + v;
        VertexConsumer vertexConsumer = pBufferSource.m_6299_(RenderType.m_110460_((ResourceLocation)pBeamLocation, (boolean)false));
        RenderUtil.renderPart(poseStack, vertexConsumer, r, g, b, 1.0f, pYOffset, maxY, 0.0f, pBeamRadius, pBeamRadius, 0.0f, maxZ, 0.0f, 0.0f, f12, u, v);
        poseStack.m_85849_();
        maxZ = -pGlowRadius;
        v = -1.0f + f2;
        u = pHeight * pTextureScale + v;
        RenderUtil.renderPart(poseStack, pBufferSource.m_6299_(RenderType.m_110460_((ResourceLocation)pBeamLocation, (boolean)true)), r, g, b, 0.7f, pYOffset, maxY, minX, maxX, pGlowRadius, minZ, maxZ, pGlowRadius, pGlowRadius, pGlowRadius, u, v);
        poseStack.m_85849_();
    }

    public static void renderPart(PoseStack poseStack, VertexConsumer pConsumer, float red, float green, float blue, float alpha, float pMinY, float pMaxY, float minX, float maxX, float minZ, float maxZ, float pX2, float pZ2, float pX3, float pZ3, float u, float v) {
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        RenderUtil.renderQuad(matrix4f, matrix3f, pConsumer, red, green, blue, alpha, pMinY, pMaxY, minX, maxX, minZ, maxZ, u, v);
        RenderUtil.renderQuad(matrix4f, matrix3f, pConsumer, red, green, blue, alpha, pMinY, pMaxY, pX3, pZ3, pX2, pZ2, u, v);
        RenderUtil.renderQuad(matrix4f, matrix3f, pConsumer, red, green, blue, alpha, pMinY, pMaxY, minZ, maxZ, pX3, pZ3, u, v);
        RenderUtil.renderQuad(matrix4f, matrix3f, pConsumer, red, green, blue, alpha, pMinY, pMaxY, pX2, pZ2, minX, maxX, u, v);
    }

    public static void renderQuad(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha, float pMinY, float pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinV, float pMaxV) {
        RenderUtil.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMaxY, pMinX, pMinZ, 1.0f, pMinV);
        RenderUtil.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMinX, pMinZ, 1.0f, pMaxV);
        RenderUtil.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxX, pMaxZ, 0.0f, pMaxV);
        RenderUtil.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMaxY, pMaxX, pMaxZ, 0.0f, pMinV);
    }

    public static void addVertex(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha, float pY, float pX, float pZ, float pU, float pV) {
        pConsumer.m_252986_(pPose, pX, pY, pZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_7421_(pU, pV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

