/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.modifier;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import ttv.migami.jeg.modifier.Modifier;
import ttv.migami.jeg.modifier.ModifierDeserializer;
import ttv.migami.jeg.modifier.ModifierRegistry;

public class ModifierLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, Modifier>> {
    private static final String DATA_FOLDER = "modifiers";
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Modifier.class, (Object)new ModifierDeserializer()).create();

    protected Map<ResourceLocation, Modifier> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, Modifier> map = new HashMap<ResourceLocation, Modifier>();
        for (Map.Entry entry : resourceManager.m_214159_(DATA_FOLDER, fileName -> fileName.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            try (InputStreamReader reader = new InputStreamReader(((Resource)entry.getValue()).m_215507_());){
                Modifier group = (Modifier)this.gson.fromJson((Reader)reader, Modifier.class);
                map.put(id, group);
            }
            catch (Exception e) {
                System.err.println("Failed to load modifier group " + id + ": " + e.getMessage());
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, Modifier> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        ModifierRegistry.setGroups(map);
        System.out.println("Loaded " + map.size() + " modifier groups");
    }
}

