/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.util;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class DyeUtils {
    public static boolean hasDye(ItemStack parent) {
        CompoundTag root = parent.m_41783_();
        if (root == null) {
            return false;
        }
        CompoundTag cosmetics = root.m_128469_("Cosmetics");
        if (!cosmetics.m_128425_("Dye", 10)) {
            return false;
        }
        CompoundTag dyeTag = cosmetics.m_128469_("Dye");
        ItemStack dyeStack = ItemStack.m_41712_((CompoundTag)dyeTag);
        return dyeStack.m_41720_() instanceof DyeItem;
    }

    public static int getStoredDyeRGB(ItemStack parent) {
        Item item;
        CompoundTag root = parent.m_41783_();
        if (root == null) {
            return 0xFFFFFF;
        }
        CompoundTag cosmetics = root.m_128469_("Cosmetics");
        if (!cosmetics.m_128425_("Dye", 10)) {
            return 0xFFFFFF;
        }
        CompoundTag dyeTag = cosmetics.m_128469_("Dye");
        ItemStack dyeStack = ItemStack.m_41712_((CompoundTag)dyeTag);
        Item item2 = dyeStack.m_41720_();
        if (item2 instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item2;
            DyeColor dyeColor = dyeItem.m_41089_();
            return dyeColor.m_41070_();
        }
        String id = dyeTag.m_128461_("id");
        if (!id.isEmpty() && (item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(id))) instanceof DyeItem) {
            DyeItem dyeItem2 = (DyeItem)item;
            return dyeItem2.m_41089_().m_41070_();
        }
        return 0xFFFFFF;
    }

    public static int red(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int green(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int blue(int rgb) {
        return rgb & 0xFF;
    }

    public static float[] asUnitFloats(int rgb) {
        return new float[]{(float)DyeUtils.red(rgb) / 255.0f, (float)DyeUtils.green(rgb) / 255.0f, (float)DyeUtils.blue(rgb) / 255.0f};
    }
}

