/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.client.VoidRevelationHandler;
import com.sammy.malum.client.screen.codex.BookEntryBuilder;
import com.sammy.malum.client.screen.codex.PlacedBookEntryBuilder;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.function.BooleanSupplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Style;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.item.Item;

public class BookEntry {
    public static final BooleanSupplier AFTER_THOROUGH_READING = () -> Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7755_().getString().equals("Dev") || BookEntry.timesOpenedBook() > 64;
    public static final BooleanSupplier AFTER_UMBRAL_CRYSTAL = () -> VoidRevelationHandler.hasSeenTheRevelation(VoidRevelationHandler.RevelationType.BLACK_CRYSTAL);
    public final String identifier;
    public final boolean isVoid;
    public final boolean isFragment;
    public final UnaryOperator<Style> titleStyle;
    public final UnaryOperator<Style> subtitleStyle;
    public final ImmutableList<BookPage> pages;
    public final ImmutableList<EntryReference> references;
    public final BooleanSupplier entryVisibleChecker;
    public final boolean tooltipDisabled;

    public BookEntry(String identifier, boolean isVoid, ImmutableList<BookPage> pages, ImmutableList<EntryReference> references, BooleanSupplier validityChecker, UnaryOperator<Style> titleStyle, UnaryOperator<Style> subtitleStyle, boolean tooltipDisabled, boolean isFragment) {
        this.identifier = identifier;
        this.isVoid = isVoid;
        this.pages = pages;
        this.references = references;
        this.entryVisibleChecker = validityChecker;
        this.titleStyle = titleStyle;
        this.subtitleStyle = subtitleStyle;
        this.tooltipDisabled = tooltipDisabled;
        this.isFragment = isFragment;
    }

    public String translationKey() {
        return "malum.gui.book.entry." + this.identifier;
    }

    public String descriptionTranslationKey() {
        return "malum.gui.book.entry." + this.identifier + ".description";
    }

    public boolean hasContents() {
        return !this.pages.isEmpty();
    }

    public boolean shouldShow() {
        return this.entryVisibleChecker.getAsBoolean();
    }

    public boolean hasTooltip() {
        return !this.tooltipDisabled;
    }

    public static PlacedBookEntryBuilder build(String identifier, int xOffset, int yOffset) {
        return new PlacedBookEntryBuilder(identifier, xOffset, yOffset);
    }

    public static BookEntryBuilder build(String identifier) {
        return new BookEntryBuilder(identifier);
    }

    public static int timesOpenedBook() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 0;
        }
        StatsCounter stats = player.m_108630_();
        int arcana = stats.m_13015_(Stats.f_12982_.m_12902_((Object)((Item)ItemRegistry.ENCYCLOPEDIA_ARCANA.get())));
        int esoterica = stats.m_13015_(Stats.f_12982_.m_12902_((Object)((Item)ItemRegistry.ENCYCLOPEDIA_ESOTERICA.get())));
        return arcana + esoterica;
    }
}

