/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.common.recipe.SpiritTransmutationRecipe;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.handlers.screenparticle.ScreenParticleHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleRegistry;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;
import team.lodestar.lodestone.systems.recipe.IRecipeComponent;
import team.lodestar.lodestone.systems.recipe.WrappedIngredient;

public class SpiritTransmutationRecipeTreePage
extends BookPage {
    private static final ScreenParticleHolder TRANSMUTATION_PARTICLES = new ScreenParticleHolder();
    private final String headlineTranslationKey;
    private final List<WrappedIngredient> itemTree = new ArrayList<WrappedIngredient>();

    public SpiritTransmutationRecipeTreePage(String headlineTranslationKey, Item start) {
        super(MalumMod.malumPath("textures/gui/book/pages/transmutation_recipe_tree_page.png"));
        this.headlineTranslationKey = headlineTranslationKey;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            SpiritTransmutationRecipe recipe = SpiritTransmutationRecipe.getRecipe((Level)level, start);
            while (true) {
                if (recipe == null) {
                    this.itemTree.add(new WrappedIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLIGHTED_SOIL.get()})));
                    break;
                }
                this.itemTree.add(new WrappedIngredient(recipe.ingredient));
                ItemStack output = recipe.output;
                recipe = SpiritTransmutationRecipe.getRecipe((Level)level, s -> s.ingredient.test(output));
            }
        }
    }

    public String headlineTranslationKey() {
        return "malum.gui.book.entry.page.headline." + this.headlineTranslationKey;
    }

    @Override
    public boolean isValid() {
        return !this.itemTree.isEmpty();
    }

    @Override
    public void render(EntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        MutableComponent component = Component.m_237115_((String)this.headlineTranslationKey());
        ArcanaCodexHelper.renderText(guiGraphics, (Component)component, left + 70 - Minecraft.m_91087_().f_91062_.m_92895_(component.getString()) / 2, top + 5);
        if (!isRepeat) {
            if (ScreenParticleHandler.canSpawnParticles) {
                TRANSMUTATION_PARTICLES.tick();
            }
            ScreenParticleHandler.renderParticles((ScreenParticleHolder)TRANSMUTATION_PARTICLES);
        }
        ArcanaCodexHelper.renderComponent(screen, guiGraphics, (IRecipeComponent)this.itemTree.get(0), left + 63, top + 38, mouseX, mouseY);
        ArcanaCodexHelper.renderComponent(screen, guiGraphics, (IRecipeComponent)this.itemTree.get(this.itemTree.size() - 1), left + 63, top + 120, mouseX, mouseY);
        int leftStart = left + 73 - this.itemTree.size() * 10;
        for (int i = 1; i < this.itemTree.size() - 1; ++i) {
            WrappedIngredient wrappedIngredient = this.itemTree.get(i);
            ArcanaCodexHelper.renderComponent(screen, guiGraphics, (IRecipeComponent)wrappedIngredient, leftStart + i * 20, top + 79, mouseX, mouseY);
        }
        int particlesX = left + 25;
        int particlesY = top + 88;
        if (ScreenParticleHandler.canSpawnParticles) {
            for (int i = 0; i < 8; ++i) {
                RandomSource rand = Minecraft.m_91087_().f_91073_.f_46441_;
                float scale = RandomHelper.randomBetween((RandomSource)rand, (float)0.1f, (float)0.2f);
                float spin = RandomHelper.randomBetween((RandomSource)rand, (float)0.2f, (float)0.4f);
                double xOffset = (float)(92L * ((Minecraft.m_91087_().f_91073_.m_46467_() + (long)(i * 30)) % 100L)) / 100.0f;
                double yOffset = Math.sin((double)((float)((Minecraft.m_91087_().f_91073_.m_46467_() + (long)(i * 16)) % 80L) / 80.0f) * Math.PI * 2.0) * 6.0;
                ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)TRANSMUTATION_PARTICLES).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.6f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)spin).build()).setScaleData(GenericParticleData.create((float)0.0f, (float)scale, (float)0.0f).build()).setColorData(SpiritTypeRegistry.ARCANE_SPIRIT.createColorData().setCoefficient(0.75f).build()).setLifetime(i % 2 == 0 ? 20 : 40).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).setLifeDelay(i > 3 ? 0 : 15).spawn((double)particlesX + xOffset, (double)particlesY + yOffset);
            }
        }
    }
}

