/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_altar;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_altar.AltarCraftingHelper;
import com.sammy.malum.common.block.curiosities.spirit_altar.AltarSoundInstance;
import com.sammy.malum.common.block.curiosities.spirit_altar.IAltarAccelerator;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.visual_effects.SpiritAltarParticleEffects;
import com.sammy.malum.visual_effects.networked.altar.SpiritAltarEatItemParticleEffect;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class SpiritAltarBlockEntity
extends LodestoneBlockEntity {
    private static final Vec3 ALTAR_ITEM_OFFSET = new Vec3(0.5, 1.25, 0.5);
    public static final int HORIZONTAL_RANGE = 4;
    public static final int VERTICAL_RANGE = 3;
    public float speed = 1.0f;
    public int progress;
    public int idleProgress;
    public float spiritYLevel;
    public List<BlockPos> acceleratorPositions = new ArrayList<BlockPos>();
    public List<IAltarAccelerator> accelerators = new ArrayList<IAltarAccelerator>();
    public float spiritAmount;
    public float spiritSpin;
    public boolean isCrafting;
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory extrasInventory;
    public LodestoneBlockEntityInventory spiritInventory;
    public Map<SpiritInfusionRecipe, AltarCraftingHelper.Ranking> possibleRecipes = new HashMap<SpiritInfusionRecipe, AltarCraftingHelper.Ranking>();
    public SpiritInfusionRecipe recipe;
    public LazyOptional<IItemHandler> internalInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.extrasInventory, this.spiritInventory}));
    public LazyOptional<IItemHandler> exposedInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.spiritInventory}));

    public SpiritAltarBlockEntity(BlockEntityType<? extends SpiritAltarBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SpiritAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.SPIRIT_ALTAR.get(), pos, state);
        this.inventory = new MalumBlockEntityInventory(1, 64, t -> !(t.m_41720_() instanceof SpiritShardItem)){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritAltarBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((Level)SpiritAltarBlockEntity.this.f_58857_, (BlockPos)SpiritAltarBlockEntity.this.f_58858_);
            }
        };
        this.extrasInventory = new MalumBlockEntityInventory(8, 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BlockHelper.updateAndNotifyState((Level)SpiritAltarBlockEntity.this.f_58857_, (BlockPos)SpiritAltarBlockEntity.this.f_58858_);
            }
        };
        this.spiritInventory = new MalumBlockEntityInventory(SpiritTypeRegistry.SPIRITS.size(), 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritAltarBlockEntity.this.needsSync = true;
                SpiritAltarBlockEntity.this.spiritAmount = Math.max(1.0f, Mth.m_14179_((float)0.15f, (float)SpiritAltarBlockEntity.this.spiritAmount, (float)(this.nonEmptyItemAmount + 1)));
                BlockHelper.updateAndNotifyState((Level)SpiritAltarBlockEntity.this.f_58857_, (BlockPos)SpiritAltarBlockEntity.this.f_58858_);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                Item item = stack.m_41720_();
                if (!(item instanceof SpiritShardItem)) {
                    return false;
                }
                SpiritShardItem spiritItem = (SpiritShardItem)item;
                for (int i = 0; i < this.getSlots(); ++i) {
                    ItemStack stackInSlot;
                    if (i == slot || (stackInSlot = this.getStackInSlot(i)).m_41619_() || stackInSlot.m_41720_() != spiritItem) continue;
                    return false;
                }
                return true;
            }
        };
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128405_("progress", this.progress);
        compound.m_128405_("idleProgress", this.idleProgress);
        compound.m_128350_("spiritYLevel", this.spiritYLevel);
        compound.m_128350_("speed", this.speed);
        compound.m_128350_("spiritAmount", this.spiritAmount);
        compound.m_128405_("acceleratorAmount", this.acceleratorPositions.size());
        for (int i = 0; i < this.acceleratorPositions.size(); ++i) {
            BlockHelper.saveBlockPos((CompoundTag)compound, (BlockPos)this.acceleratorPositions.get(i), (String)("" + i));
        }
        this.inventory.save(compound);
        this.spiritInventory.save(compound, "spiritInventory");
        this.extrasInventory.save(compound, "extrasInventory");
    }

    public void m_142466_(CompoundTag compound) {
        this.progress = compound.m_128451_("progress");
        this.idleProgress = compound.m_128451_("idleProgress");
        this.spiritYLevel = compound.m_128457_("spiritYLevel");
        this.speed = compound.m_128457_("speed");
        this.spiritAmount = compound.m_128457_("spiritAmount");
        this.acceleratorPositions.clear();
        this.accelerators.clear();
        int amount = compound.m_128451_("acceleratorAmount");
        for (int i = 0; i < amount; ++i) {
            BlockEntity blockEntity;
            BlockPos pos = BlockHelper.loadBlockPos((CompoundTag)compound, (String)("" + i));
            if (this.f_58857_ == null || !((blockEntity = this.f_58857_.m_7702_(pos)) instanceof IAltarAccelerator)) continue;
            IAltarAccelerator accelerator = (IAltarAccelerator)blockEntity;
            this.acceleratorPositions.add(pos);
            this.accelerators.add(accelerator);
        }
        this.inventory.load(compound);
        this.spiritInventory.load(compound, "spiritInventory");
        this.extrasInventory.load(compound, "extrasInventory");
        super.m_142466_(compound);
    }

    public void onBreak(@Nullable Player player) {
        this.inventory.dumpItems(this.f_58857_, this.f_58858_);
        this.spiritInventory.dumpItems(this.f_58857_, this.f_58858_);
        this.extrasInventory.dumpItems(this.f_58857_, this.f_58858_);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            ItemStack stack;
            ItemStack heldStack = player.m_21205_();
            this.recalibrateAccelerators();
            if (!(heldStack.m_41720_() instanceof SpiritShardItem) && !(stack = this.inventory.interact(this.f_58857_, player, hand)).m_41619_()) {
                return InteractionResult.SUCCESS;
            }
            this.spiritInventory.interact(this.f_58857_, player, hand);
            if (heldStack.m_41619_()) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.onUse(player, hand);
    }

    public void init() {
        this.recalculateRecipes();
        if (this.f_58857_.f_46443_ && this.isCrafting) {
            AltarSoundInstance.playSound(this);
        }
    }

    public void tick() {
        int progressCap;
        super.tick();
        this.spiritAmount = Math.max(1.0f, Mth.m_14179_((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.nonEmptyItemAmount));
        if (!this.inventory.getStackInSlot(0).m_41619_()) {
            ++this.idleProgress;
            progressCap = (int)(20.0f / this.speed);
            if (this.idleProgress >= progressCap) {
                this.recalculateRecipes();
                this.idleProgress = 0;
                BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
        }
        if (!this.possibleRecipes.isEmpty()) {
            if (this.spiritYLevel < 30.0f) {
                this.spiritYLevel += 1.0f;
            }
            if (this.recipe != null) {
                if (!this.isCrafting) {
                    BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
                    this.isCrafting = true;
                }
                ++this.progress;
            } else {
                if (this.isCrafting) {
                    BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
                    this.isCrafting = false;
                }
                this.progress = 0;
            }
            if (!this.f_58857_.f_46443_) {
                boolean success;
                boolean canAccelerate;
                if (this.f_58857_.m_46467_() % 20L == 0L && !(canAccelerate = this.accelerators.stream().allMatch(IAltarAccelerator::canAccelerate))) {
                    this.recalibrateAccelerators();
                }
                if (this.progress >= (progressCap = (int)(300.0f / this.speed)) && (success = this.consume())) {
                    this.craft();
                }
            }
        } else {
            this.isCrafting = false;
            this.progress = 0;
            if (this.spiritYLevel > 0.0f) {
                this.spiritYLevel = Math.max(this.spiritYLevel - 0.8f, 0.0f);
            }
        }
        if (this.f_58857_.f_46443_) {
            this.spiritSpin += 1.0f + this.spiritYLevel * 0.05f + this.speed * 0.5f;
            SpiritAltarParticleEffects.passiveSpiritAltarParticles(this);
        }
    }

    private void recalculateRecipes() {
        boolean hadRecipe = this.recipe != null;
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.m_41619_()) {
            Collection recipes = DataHelper.getAll(SpiritInfusionRecipe.getRecipes(this.f_58857_), r -> r.doesInputMatch(stack) && r.doSpiritsMatch(this.spiritInventory.nonEmptyItemStacks));
            this.possibleRecipes.clear();
            IItemHandlerModifiable pedestalItems = AltarCraftingHelper.createPedestalInventoryCapture(AltarCraftingHelper.capturePedestals(this.f_58857_, this.f_58858_));
            for (SpiritInfusionRecipe recipe : recipes) {
                this.possibleRecipes.put(recipe, AltarCraftingHelper.rankRecipe(recipe, stack, (IItemHandlerModifiable)this.spiritInventory, pedestalItems, (IItemHandlerModifiable)this.extrasInventory));
            }
            this.recipe = this.possibleRecipes.entrySet().stream().filter(it -> it.getValue() != null).max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        } else {
            this.recipe = null;
            this.possibleRecipes.clear();
        }
        if (hadRecipe && this.recipe == null && this.f_58857_ != null) {
            this.extrasInventory.dumpItems(this.f_58857_, this.f_58858_);
        }
    }

    public boolean consume() {
        if (this.recipe == null) {
            return false;
        }
        if (this.recipe.extraItems.isEmpty()) {
            return true;
        }
        List<IMalumSpecialItemAccessPoint> pedestalItems = AltarCraftingHelper.capturePedestals(this.f_58857_, this.f_58858_);
        ItemStack stack = this.inventory.getStackInSlot(0);
        AltarCraftingHelper.Ranking reranking = AltarCraftingHelper.rankRecipe(this.recipe, stack, (IItemHandlerModifiable)this.spiritInventory, AltarCraftingHelper.createPedestalInventoryCapture(pedestalItems), (IItemHandlerModifiable)this.extrasInventory);
        if (!Objects.equals(reranking, this.possibleRecipes.get((Object)this.recipe))) {
            this.recalculateRecipes();
            return false;
        }
        IngredientWithCount nextIngredient = AltarCraftingHelper.getNextIngredientToTake(this.recipe, (IItemHandlerModifiable)this.extrasInventory);
        if (nextIngredient != null) {
            for (IMalumSpecialItemAccessPoint provider : pedestalItems) {
                LodestoneBlockEntityInventory inventoryForAltar = provider.getSuppliedInventory();
                ItemStack providedStack = inventoryForAltar.extractItem(0, nextIngredient.count, true);
                if (!nextIngredient.ingredient.test(providedStack)) continue;
                this.f_58857_.m_5594_(null, provider.getAccessPointBlockPos(), (SoundEvent)SoundRegistry.ALTAR_CONSUME.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
                ParticleEffectTypeRegistry.SPIRIT_ALTAR_EATS_ITEM.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), ColorEffectData.fromRecipe(this.recipe.spirits), SpiritAltarEatItemParticleEffect.createData(provider.getAccessPointBlockPos(), providedStack));
                this.extrasInventory.insertItem(inventoryForAltar.extractItem(0, nextIngredient.count, false));
                inventoryForAltar.updateData();
                BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)provider.getAccessPointBlockPos());
                break;
            }
            this.progress = (int)((float)this.progress * 0.8f);
            if (this.extrasInventory.isEmpty()) {
                return false;
            }
            return AltarCraftingHelper.extractIngredient((IItemHandler)this.extrasInventory, (Predicate<ItemStack>)nextIngredient.ingredient, nextIngredient.count, true).isEmpty();
        }
        return true;
    }

    public void craft() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        ItemStack outputStack = this.recipe.output.m_41777_();
        Vec3 itemPos = this.getItemPos();
        if (this.recipe.useNbtFromInput && this.inventory.getStackInSlot(0).m_41782_()) {
            outputStack.m_41751_(stack.m_41783_());
        }
        stack.m_41774_(this.recipe.input.count);
        this.inventory.updateData();
        block0: for (SpiritWithCount spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.matches(spiritStack)) continue;
                spiritStack.m_41774_(spirit.count);
                continue block0;
            }
        }
        this.spiritInventory.updateData();
        this.progress = (int)((float)this.progress * 0.75f);
        this.extrasInventory.clear();
        ParticleEffectTypeRegistry.SPIRIT_ALTAR_CRAFTS.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), ColorEffectData.fromRecipe(this.recipe.spirits));
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.ALTAR_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, outputStack));
        this.init();
        this.recalibrateAccelerators();
        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void recalibrateAccelerators() {
        this.speed = 1.0f;
        this.accelerators.clear();
        this.acceleratorPositions.clear();
        Collection nearbyAccelerators = BlockHelper.getBlockEntities(IAltarAccelerator.class, (Level)this.f_58857_, (BlockPos)this.f_58858_, (int)4, (int)3, (int)4);
        HashMap<IAltarAccelerator.AltarAcceleratorType, Integer> entries = new HashMap<IAltarAccelerator.AltarAcceleratorType, Integer>();
        for (IAltarAccelerator accelerator : nearbyAccelerators) {
            if (!accelerator.canAccelerate()) continue;
            int max = accelerator.getAcceleratorType().maximumEntries();
            int amount = entries.computeIfAbsent(accelerator.getAcceleratorType(), a -> 0);
            if (amount >= max) continue;
            this.accelerators.add(accelerator);
            this.acceleratorPositions.add(((BlockEntity)accelerator).m_58899_());
            this.speed += accelerator.getAcceleration();
            entries.replace(accelerator.getAcceleratorType(), amount + 1);
        }
    }

    public Vec3 getCentralItemOffset() {
        return ALTAR_ITEM_OFFSET;
    }

    public Vec3 getItemPos() {
        BlockPos blockPos = this.m_58899_();
        Vec3 offset = this.getCentralItemOffset();
        return new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
    }

    public Vec3 getSpiritItemOffset(int slot, float partialTicks) {
        float projectedSpiritSpin = this.spiritSpin + this.spiritYLevel * 0.05f + this.speed * 0.5f;
        float lerpSpiritSpin = this.spiritSpin + partialTicks * (projectedSpiritSpin - this.spiritSpin);
        float distance = 1.0f - this.getSpinUp(Easing.SINE_OUT) * 0.25f + (float)Math.sin(lerpSpiritSpin % 6.28f / 20.0f) * 0.025f;
        float height = 0.75f + this.getSpinUp(Easing.QUARTIC_OUT) * this.getSpinUp((Easing)Easing.BACK_OUT) * 0.5f;
        int period = 360;
        double angle = (double)((float)slot / this.spiritAmount) * (Math.PI * 2);
        double dx2 = (double)distance * Math.cos(angle += (double)(lerpSpiritSpin % (float)period / (float)period) * (Math.PI * 2));
        double dz2 = (double)distance * Math.sin(angle);
        Vec3 vector2f = new Vec3(dx2, 0.0, dz2);
        double x = vector2f.f_82479_ * (double)distance;
        double z = vector2f.f_82481_ * (double)distance;
        return new Vec3(x + 0.5, (double)height, z + 0.5);
    }

    public float getSpinUp(Easing easing) {
        if (this.spiritYLevel > 30.0f) {
            return 1.0f;
        }
        return easing.ease(this.spiritYLevel / 30.0f, 0.0f, 1.0f, 1.0f);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.internalInventory.cast();
            }
            return this.exposedInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.f_58858_;
        return new AABB((double)(pos.m_123341_() - 1), (double)pos.m_123342_(), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 2));
    }
}

