/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.nitrate;

import com.sammy.malum.common.entity.nitrate.NitrateExplosion;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.rendering.trail.TrailPoint;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class AbstractNitrateEntity
extends ThrowableProjectile {
    protected static final EntityDataAccessor<Boolean> DATA_FADING_AWAY = SynchedEntityData.m_135353_(AbstractNitrateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int MAX_AGE = 1200;
    public static final Color SECOND_SMOKE_COLOR = new Color(30, 30, 30);
    public static final float MAIN_TRAIL_LENGTH = 12.0f;
    public final TrailPointBuilder trailPointBuilder = TrailPointBuilder.create((int)12);
    public final TrailPointBuilder spinningTrailPointBuilder = TrailPointBuilder.create((int)6);
    public float spinOffset = (float)((double)this.f_19796_.m_188501_() * Math.PI * 2.0);
    public int age;
    public int timesExploded;
    public boolean fadingAway;

    public AbstractNitrateEntity(EntityType<? extends AbstractNitrateEntity> type, Level level) {
        super(type, level);
    }

    public AbstractNitrateEntity(EntityType<? extends AbstractNitrateEntity> type, LivingEntity owner, Level level) {
        super(type, owner, level);
    }

    public void onExplode() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void spawnParticles();

    public abstract int getMaxPierce();

    public abstract float getExplosionRadius();

    public abstract ParticleEffectType getImpactParticleEffect();

    public abstract ColorEffectData getImpactParticleEffectColor();

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_FADING_AWAY, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_FADING_AWAY.equals(pKey)) {
            this.fadingAway = (Boolean)this.f_19804_.m_135370_(DATA_FADING_AWAY);
            if (this.fadingAway) {
                this.age = 1180;
            }
        }
        super.m_7350_(pKey);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.age != 0) {
            compound.m_128405_("age", this.age);
        }
        if (this.timesExploded != 0) {
            compound.m_128405_("timesExploded", this.timesExploded);
        }
        if (this.fadingAway) {
            compound.m_128379_("fadingAway", true);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.age = compound.m_128451_("age");
        this.timesExploded = compound.m_128451_("pierce");
        this.m_20088_().m_135381_(DATA_FADING_AWAY, (Object)compound.m_128471_("fadingAway"));
    }

    protected void m_6532_(HitResult pResult) {
        if (this.fadingAway) {
            return;
        }
        NitrateExplosion.explode(this.m_9236_(), (Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), this.getExplosionRadius(), Explosion.BlockInteraction.DESTROY);
        this.onExplode();
        if (!this.m_9236_().f_46443_) {
            this.getImpactParticleEffect().createPositionedEffect(this.m_9236_(), new PositionEffectData(this.m_20182_()), this.getImpactParticleEffectColor());
        }
        if (this.timesExploded++ >= this.getMaxPierce()) {
            this.m_20088_().m_135381_(DATA_FADING_AWAY, (Object)true);
            this.m_20256_(this.m_20184_().m_82490_((double)0.05f));
        }
        super.m_6532_(pResult);
    }

    public void m_8119_() {
        int i;
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        if (!this.fadingAway) {
            this.m_20334_(motion.f_82479_ * (double)0.99f, (motion.f_82480_ - (double)0.015f) * (double)0.99f, motion.f_82481_ * (double)0.99f);
        }
        float radialOffsetScale = this.fadingAway ? 0.0f : 0.15f;
        float randomOffsetScale = this.age > 5 ? Math.min((float)(this.age - 5) * 0.02f, 0.2f) : 0.0f;
        for (i = 0; i < 2; ++i) {
            float progress = (float)i * 0.5f;
            final Vec3 position = this.m_20318_(progress);
            final Vec3 randomizedPosition = position.m_82520_((double)(this.f_19796_.m_188501_() * randomOffsetScale), (double)(this.f_19796_.m_188501_() * randomOffsetScale), (double)(this.f_19796_.m_188501_() * randomOffsetScale));
            this.trailPointBuilder.addTrailPoint(new TrailPoint(position, i){

                public Vec3 getPosition() {
                    return new Vec3(Mth.m_14139_((double)((float)this.getTimeActive() / 12.0f), (double)position.f_82479_, (double)randomizedPosition.f_82479_), Mth.m_14139_((double)((float)this.getTimeActive() / 12.0f), (double)position.f_82480_, (double)randomizedPosition.f_82480_), Mth.m_14139_((double)((float)this.getTimeActive() / 12.0f), (double)position.f_82481_, (double)randomizedPosition.f_82481_));
                }
            });
            this.spinningTrailPointBuilder.addTrailPoint(new TrailPoint(position.m_82520_(Math.cos(this.spinOffset + ((float)this.age + progress) / 2.0f) * (double)radialOffsetScale, 0.0, Math.sin(this.spinOffset + ((float)this.age + progress) / 2.0f) * (double)radialOffsetScale), i));
        }
        for (i = 0; i < (this.fadingAway || this.age > 1180 ? 2 : 1); ++i) {
            this.trailPointBuilder.tickTrailPoints();
            this.spinningTrailPointBuilder.tickTrailPoints();
        }
        ++this.age;
        if (this.age > 1200) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_ && !this.fadingAway && this.age > 1) {
            this.spawnParticles();
        }
    }

    public float getVisualEffectScalar() {
        float effectScalar;
        float f = effectScalar = this.fadingAway ? 1.0f - (float)(this.age - 1200 + 10) / 10.0f : 1.0f;
        if (this.age < 5) {
            effectScalar = (float)this.age / 5.0f;
        }
        return effectScalar;
    }

    public boolean m_20069_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public float m_6143_() {
        return 4.0f;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }
}

