/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.cosmetic.skins;

import com.sammy.malum.client.cosmetic.ArmorSkinRenderingData;
import com.sammy.malum.registry.common.item.ArmorSkinRegistry;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.item.LodestoneArmorItem;

public abstract class ArmorSkin {
    public static final String MALUM_SKIN_TAG = "malum:item_skin";
    public static int indexCounter;
    public final String id;
    public final Class<? extends LodestoneArmorItem> validArmorClass;
    public final Item weaveItem;
    public final int index;

    public ArmorSkin(String id, Class<? extends LodestoneArmorItem> validArmorClass, Item weaveItem) {
        this.id = id;
        this.validArmorClass = validArmorClass;
        this.weaveItem = weaveItem;
        this.index = indexCounter++;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract ArmorSkinRenderingData getRenderingData();

    public static String getApplicableItemSkinTag(ItemStack target, ItemStack weave) {
        for (Map.Entry<String, ArmorSkin> entry : ArmorSkinRegistry.SKINS.entrySet()) {
            if (!entry.getValue().validArmorClass.isInstance(target.m_41720_()) || !entry.getValue().weaveItem.equals(weave.m_41720_())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static ArmorSkin getAppliedItemSkin(ItemStack stack) {
        return stack.m_41782_() ? ArmorSkinRegistry.SKINS.get(stack.m_41783_().m_128461_(MALUM_SKIN_TAG)) : null;
    }

    public static class ArmorSkinDatagenData {
        public final String itemTexturePrefix;
        public final String itemModelPrefix;
        public final String helmetSuffix;
        public final String chestplateSuffix;
        public final String leggingsSuffix;
        public final String bootsSuffix;

        public ArmorSkinDatagenData(String itemTexturePrefix, String itemModelPrefix, String helmetSuffix, String chestplateSuffix, String leggingsSuffix, String bootsSuffix) {
            this.itemTexturePrefix = itemTexturePrefix;
            this.itemModelPrefix = itemModelPrefix;
            this.helmetSuffix = helmetSuffix;
            this.chestplateSuffix = chestplateSuffix;
            this.leggingsSuffix = leggingsSuffix;
            this.bootsSuffix = bootsSuffix;
        }

        public String getSuffix(LodestoneArmorItem item) {
            switch (item.m_40402_()) {
                case HEAD: {
                    return this.helmetSuffix;
                }
                case CHEST: {
                    return this.chestplateSuffix;
                }
                case LEGS: {
                    return this.leggingsSuffix;
                }
                case FEET: {
                    return this.bootsSuffix;
                }
            }
            return null;
        }
    }
}

