/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.runes;

import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.common.spiritrite.PotionRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class TotemicRuneCurioItem
extends AbstractRuneCurioItem {
    public final Supplier<MobEffect> mobEffectSupplier;
    public final Predicate<LivingEntity> entityPredicate;
    private final int interval;

    public TotemicRuneCurioItem(Item.Properties builder, TotemicRiteType riteType, boolean corrupted) {
        this(builder, riteType, corrupted, 40);
    }

    public TotemicRuneCurioItem(Item.Properties builder, TotemicRiteType riteType, boolean corrupted, int interval) {
        super(builder, riteType.getIdentifyingSpirit());
        this.interval = interval;
        TotemicRiteEffect totemicRiteEffect = riteType.getRiteEffect(corrupted);
        if (!(totemicRiteEffect instanceof PotionRiteEffect)) {
            throw new IllegalArgumentException("Supplied rite type must have an aura effect");
        }
        PotionRiteEffect potionRiteEffect = (PotionRiteEffect)totemicRiteEffect;
        this.mobEffectSupplier = potionRiteEffect.mobEffectSupplier;
        this.entityPredicate = potionRiteEffect.getEntityPredicate();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_9236_().m_46467_() % (long)this.interval == 0L && this.entityPredicate.test(livingEntity)) {
            livingEntity.m_7292_(new MobEffectInstance(this.mobEffectSupplier.get(), 200, 0, true, true));
        }
        super.curioTick(slotContext, stack);
    }
}

