/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.staff;

import com.google.common.collect.ImmutableMultimap;
import com.sammy.malum.common.capability.MalumPlayerDataCapability;
import com.sammy.malum.common.enchantment.staff.ReplenishingEnchantment;
import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.item.ModCombatItem;

public abstract class AbstractStaffItem
extends ModCombatItem
implements IMalumEventResponderItem {
    public final float chargeDuration;
    public final float magicDamage;

    public AbstractStaffItem(Tier tier, float attackSpeed, int chargeDuration, float magicDamage, Item.Properties builderIn) {
        super(tier, 1.0f, -2.8f + attackSpeed, builderIn);
        this.chargeDuration = chargeDuration;
        this.magicDamage = magicDamage;
    }

    public AbstractStaffItem(Tier tier, int chargeDuration, float magicDamage, Item.Properties builderIn) {
        this(tier, 0.0f, chargeDuration, magicDamage, builderIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void spawnChargeParticles(Level var1, LivingEntity var2, Vec3 var3, ItemStack var4, float var5);

    public abstract int getCooldownDuration(Level var1, LivingEntity var2);

    public abstract int getProjectileCount(Level var1, LivingEntity var2, float var3);

    public abstract void fireProjectile(LivingEntity var1, ItemStack var2, Level var3, InteractionHand var4, float var5, int var6);

    public ImmutableMultimap.Builder<Attribute, AttributeModifier> createExtraAttributes() {
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        builder.put((Object)((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get()), (Object)new AttributeModifier((UUID)LodestoneAttributeRegistry.UUIDS.get(LodestoneAttributeRegistry.MAGIC_DAMAGE), "Weapon magic damage", (double)this.magicDamage, AttributeModifier.Operation.ADDITION));
        return builder;
    }

    public void hurtEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (!(event.getSource().m_7640_() instanceof AbstractBoltProjectileEntity)) {
                Level level = player.m_9236_();
                AbstractStaffItem.spawnSweepParticles(player, (SimpleParticleType)ParticleRegistry.STAFF_SLAM_PARTICLE.get());
                level.m_5594_(null, target.m_20183_(), (SoundEvent)SoundRegistry.STAFF_STRIKES.get(), attacker.m_5720_(), 0.75f, Mth.m_216267_((RandomSource)level.f_46441_, (float)0.5f, (float)1.0f));
                if (event.getSource().m_269533_(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) {
                    ReplenishingEnchantment.replenishStaffCooldown(attacker, stack);
                }
            }
        }
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        float chargePercentage = Math.min(this.chargeDuration, (float)(this.m_8105_(pStack) - pTimeCharged)) / this.chargeDuration;
        int projectileCount = this.getProjectileCount(pLevel, pLivingEntity, chargePercentage);
        if (projectileCount > 0) {
            InteractionHand hand = pLivingEntity.m_7655_();
            if (!pLevel.f_46443_) {
                float magicDamage = (float)pLivingEntity.m_21204_().m_22181_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get());
                if (magicDamage == 0.0f) {
                    float pitch = Mth.m_216267_((RandomSource)pLevel.f_46441_, (float)0.5f, (float)0.8f);
                    pLevel.m_5594_(null, pLivingEntity.m_20183_(), (SoundEvent)SoundRegistry.STAFF_SIZZLES.get(), SoundSource.PLAYERS, 0.5f, pitch);
                    pLivingEntity.m_21011_(hand, true);
                    return;
                }
                for (int i = 0; i < projectileCount; ++i) {
                    this.fireProjectile(pLivingEntity, pStack, pLevel, hand, chargePercentage, i);
                }
                if (pLivingEntity instanceof Player) {
                    Player player = (Player)pLivingEntity;
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    if (!player.m_150110_().f_35937_) {
                        pStack.m_41622_(2, (LivingEntity)player, p_220009_1_ -> p_220009_1_.m_21190_(hand));
                        MalumPlayerDataCapability capability = MalumPlayerDataCapability.getCapability(player);
                        if (capability.reserveStaffChargeHandler.chargeCount > 0) {
                            --capability.reserveStaffChargeHandler.chargeCount;
                        } else {
                            player.m_36335_().m_41524_((Item)this, this.getCooldownDuration(pLevel, pLivingEntity));
                        }
                    }
                    player.m_21011_(hand, true);
                }
            }
        } else {
            float pitch = Mth.m_216267_((RandomSource)pLevel.f_46441_, (float)0.5f, (float)0.8f);
            pLevel.m_5594_(null, pLivingEntity.m_20183_(), (SoundEvent)SoundRegistry.STAFF_SIZZLES.get(), SoundSource.PLAYERS, 0.5f, pitch);
        }
        super.m_5551_(pStack, pLevel, pLivingEntity, pTimeCharged);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        int useDuration = this.m_8105_(pStack);
        float chargePercentage = Math.min(this.chargeDuration, (float)(useDuration - pRemainingUseDuration)) / this.chargeDuration;
        if (pLevel.f_46443_) {
            InteractionHand hand = pLivingEntity.m_7655_();
            Vec3 pos = this.getProjectileSpawnPos(pLivingEntity, hand, 1.5f, 0.6f);
            this.spawnChargeParticles(pLevel, pLivingEntity, pos, pStack, chargePercentage);
        }
        if ((float)pRemainingUseDuration == (float)useDuration - this.chargeDuration) {
            float pitch = Mth.m_216267_((RandomSource)pLevel.f_46441_, (float)1.2f, (float)1.6f);
            pLevel.m_5594_(null, pLivingEntity.m_20183_(), (SoundEvent)SoundRegistry.STAFF_CHARGED.get(), SoundSource.PLAYERS, 1.25f, pitch);
        } else if ((float)pRemainingUseDuration > (float)useDuration - this.chargeDuration && pRemainingUseDuration % 5 == 0) {
            float pitch = 0.25f + chargePercentage + Mth.m_216267_((RandomSource)pLevel.f_46441_, (float)0.2f, (float)0.6f);
            pLevel.m_5594_(null, pLivingEntity.m_20183_(), (SoundEvent)SoundRegistry.STAFF_POWERS_UP.get(), SoundSource.PLAYERS, 0.75f, pitch);
        } else if (pRemainingUseDuration % 5 == 0) {
            float pitch = Mth.m_216267_((RandomSource)pLevel.f_46441_, (float)0.2f, (float)0.6f);
            pLevel.m_5594_(null, pLivingEntity.m_20183_(), (SoundEvent)SoundRegistry.STAFF_POWERS_UP.get(), SoundSource.PLAYERS, 0.5f, pitch);
        }
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (pPlayer.m_36335_().m_41519_(itemstack.m_41720_())) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public static void spawnSweepParticles(Player player, SimpleParticleType type) {
        double d0 = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
        double d1 = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)type, player.m_20185_() + d0, player.m_20227_(0.5), player.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public Vec3 getProjectileSpawnPos(LivingEntity player, InteractionHand hand, float distance, float spread) {
        int angle = hand == InteractionHand.MAIN_HAND ? 225 : 90;
        double radians = Math.toRadians((float)angle - player.f_20885_);
        return player.m_20182_().m_82549_(player.m_20154_().m_82490_((double)distance)).m_82520_((double)spread * Math.sin(radians), (double)(player.m_20206_() * 0.9f), (double)spread * Math.cos(radians));
    }
}

