/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.staff;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.entity.bolt.DrainingBoltEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import java.awt.Color;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class ErosionScepterItem
extends AbstractStaffItem {
    public static final Color MALIGNANT_PURPLE = new Color(68, 11, 61);
    public static final Color MALIGNANT_BLACK = new Color(12, 4, 11);
    public static final ColorParticleData MALIGNANT_COLOR_DATA = ColorParticleData.create((Color)MALIGNANT_PURPLE, (Color)MALIGNANT_BLACK).setEasing(Easing.BOUNCE_IN_OUT).setCoefficient(1.2f).build();

    public ErosionScepterItem(Tier tier, float magicDamage, Item.Properties builderIn) {
        super(tier, 10, magicDamage, builderIn);
    }

    @Override
    public void hurtEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (!(event.getSource().m_7640_() instanceof AbstractBoltProjectileEntity) && !event.getSource().m_269533_(LodestoneDamageTypeTags.IS_MAGIC)) {
            MobEffect silenced = (MobEffect)MobEffectRegistry.SILENCED.get();
            MobEffectInstance effect = target.m_21124_(silenced);
            if (effect == null) {
                target.m_7292_(new MobEffectInstance(silenced, 300, 1, true, true, true));
            } else {
                EntityHelper.amplifyEffect((MobEffectInstance)effect, (LivingEntity)target, (int)2, (int)9);
                EntityHelper.extendEffect((MobEffectInstance)effect, (LivingEntity)target, (int)60, (int)600);
            }
            SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)SoundRegistry.DRAINING_MOTIF.get()), (SoundSource)attacker.m_5720_(), (float)1.0f, (float)1.25f);
        }
        super.hurtEvent(event, attacker, target, stack);
    }

    @Override
    public int getCooldownDuration(Level level, LivingEntity livingEntity) {
        return 80;
    }

    @Override
    public int getProjectileCount(Level level, LivingEntity livingEntity, float pct) {
        return pct == 1.0f ? 2 : 0;
    }

    @Override
    public void fireProjectile(LivingEntity player, ItemStack stack, Level level, InteractionHand hand, float chargePercentage, int count) {
        int spawnDelay = count * 5;
        float pitchOffset = (float)count * 1.5f;
        float velocity = 4.0f;
        float magicDamage = (float)player.m_21204_().m_22181_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get()) * 0.3f;
        Vec3 pos = this.getProjectileSpawnPos(player, hand, 0.5f, 0.5f);
        for (int i = 0; i < 4; ++i) {
            float xSpread = RandomHelper.randomBetween((RandomSource)level.f_46441_, (float)-0.125f, (float)0.125f);
            float ySpread = RandomHelper.randomBetween((RandomSource)level.f_46441_, (float)-0.025f, (float)0.025f);
            DrainingBoltEntity entity = new DrainingBoltEntity(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
            if (i > 1) {
                entity.m_20225_(true);
            }
            entity.setData((Entity)player, magicDamage, spawnDelay);
            entity.m_37446_(stack);
            entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -pitchOffset, velocity, 0.0f);
            Vec3 projectileDirection = entity.m_20184_();
            float yRot = (float)(Mth.m_14136_((double)projectileDirection.f_82479_, (double)projectileDirection.f_82481_) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.m_82537_(projectileDirection);
            entity.m_20256_(entity.m_20184_().m_82549_(left.m_82490_((double)xSpread)).m_82549_(up.m_82490_((double)ySpread)));
            level.m_7967_((Entity)entity);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnChargeParticles(Level pLevel, LivingEntity pLivingEntity, Vec3 pos, ItemStack pStack, float pct) {
        RandomSource random = pLevel.f_46441_;
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)random, (float)0.25f, (float)0.5f).setSpinOffset(RandomHelper.randomBetween((RandomSource)random, (float)0.0f, (float)6.28f)).build();
        WorldParticleBuilder.create(ParticleRegistry.CIRCLE, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(pLivingEntity.m_20154_().m_82541_())).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setTransparencyData(GenericParticleData.create((float)(0.8f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(0.3f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)MALIGNANT_BLACK, (Color)MALIGNANT_BLACK).build()).setLifetime(5).setLifeDelay(2).setMotion(pLivingEntity.m_20154_().m_82541_().m_82490_((double)0.05f)).enableNoClip().enableForcedSpawn().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }
}

