/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets;

import com.sammy.malum.common.capability.MalumLivingEntityDataCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import team.lodestar.lodestone.systems.network.LodestoneClientPacket;

public class VoidRejectionPacket
extends LodestoneClientPacket {
    private final int entityId;

    public VoidRejectionPacket(int entityId) {
        this.entityId = entityId;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void execute(Supplier<NetworkEvent.Context> context) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            MalumLivingEntityDataCapability.getCapabilityOptional(livingEntity).ifPresent(c -> c.touchOfDarknessHandler.reject(livingEntity));
        }
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, VoidRejectionPacket.class, VoidRejectionPacket::encode, VoidRejectionPacket::decode, LodestoneClientPacket::handle);
    }

    public static VoidRejectionPacket decode(FriendlyByteBuf buf) {
        return new VoidRejectionPacket(buf.readInt());
    }
}

