/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.AbstractSpiritListMalumRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class SpiritFocusingRecipe
extends AbstractSpiritListMalumRecipe {
    public static final String NAME = "spirit_focusing";
    public final int time;
    public final int durabilityCost;
    public final Ingredient input;
    public final ItemStack output;

    public SpiritFocusingRecipe(ResourceLocation id, int time, int durabilityCost, Ingredient input, ItemStack output, List<SpiritWithCount> spirits) {
        super(id, (RecipeSerializer)RecipeSerializerRegistry.FOCUSING_RECIPE_SERIALIZER.get(), (RecipeType)RecipeTypeRegistry.SPIRIT_FOCUSING.get(), spirits);
        this.time = time;
        this.durabilityCost = durabilityCost;
        this.input = input;
        this.output = output;
    }

    public boolean doesInputMatch(ItemStack input) {
        return this.input.test(input);
    }

    public boolean doesOutputMatch(ItemStack output) {
        return output.m_41720_().equals(this.output.m_41720_());
    }

    public static SpiritFocusingRecipe getRecipe(Level level, ItemStack stack, List<ItemStack> spirits) {
        return SpiritFocusingRecipe.getRecipe(level, c -> c.doesInputMatch(stack) && c.doSpiritsMatch(spirits));
    }

    public static SpiritFocusingRecipe getRecipe(Level level, Predicate<SpiritFocusingRecipe> predicate) {
        return SpiritFocusingRecipe.getRecipe(level, (RecipeType)RecipeTypeRegistry.SPIRIT_FOCUSING.get(), predicate);
    }

    public static List<SpiritFocusingRecipe> getRecipes(Level level) {
        return SpiritFocusingRecipe.getRecipes(level, (RecipeType)RecipeTypeRegistry.SPIRIT_FOCUSING.get());
    }

    public static class Serializer
    implements RecipeSerializer<SpiritFocusingRecipe> {
        public SpiritFocusingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int time = json.getAsJsonPrimitive("time").getAsInt();
            int durabilityCost = json.getAsJsonPrimitive("durabilityCost").getAsInt();
            JsonObject inputObject = json.getAsJsonObject("input");
            Ingredient input = Ingredient.m_43917_((JsonElement)inputObject);
            JsonObject outputObject = json.getAsJsonObject("output");
            ItemStack output = CraftingHelper.getItemStack((JsonObject)outputObject, (boolean)true);
            JsonArray spiritsArray = json.getAsJsonArray("spirits");
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritsArray.size(); ++i) {
                JsonObject spiritObject = spiritsArray.get(i).getAsJsonObject();
                spirits.add(SpiritWithCount.deserialize(spiritObject));
            }
            if (spirits.isEmpty()) {
                return null;
            }
            return new SpiritFocusingRecipe(recipeId, time, durabilityCost, input, output, spirits);
        }

        @Nullable
        public SpiritFocusingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int time = buffer.readInt();
            int durabilityCost = buffer.readInt();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int spiritCount = buffer.readInt();
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritCount; ++i) {
                spirits.add(new SpiritWithCount(buffer.m_130267_()));
            }
            return new SpiritFocusingRecipe(recipeId, time, durabilityCost, input, output, spirits);
        }

        public void toNetwork(FriendlyByteBuf buffer, SpiritFocusingRecipe recipe) {
            buffer.writeInt(recipe.time);
            buffer.writeInt(recipe.durabilityCost);
            recipe.input.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.writeInt(recipe.spirits.size());
            for (SpiritWithCount item : recipe.spirits) {
                buffer.m_130055_(item.getStack());
            }
        }
    }
}

