/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class SacredRiteType
extends TotemicRiteType {
    public static final Map<Class<? extends Mob>, NourishmentRiteActor<?>> NOURISHMENT_RITE_ACTORS = (Map)Util.m_137469_(new HashMap(), m -> {
        m.put(Sheep.class, new NourishmentRiteActor<Sheep>(Sheep.class){

            @Override
            public void act(TotemBaseBlockEntity totemBaseBlockEntity, Sheep sheep) {
                if (sheep.m_217043_().m_188501_() < 0.6f) {
                    BlockPos blockpos = sheep.m_20183_();
                    Level level = sheep.m_9236_();
                    if (EatBlockGoal.f_25201_.test(level.m_8055_(blockpos)) || level.m_8055_(blockpos.m_7495_()).m_60713_(Blocks.f_50440_)) {
                        EatBlockGoal goal = sheep.f_29803_;
                        goal.m_8056_();
                        ParticleEffectTypeRegistry.HEXING_SMOKE.createEntityEffect((Entity)sheep, new ColorEffectData(SpiritTypeRegistry.SACRED_SPIRIT.getPrimaryColor()));
                    }
                }
            }
        });
        m.put(Bee.class, new NourishmentRiteActor<Bee>(Bee.class){

            @Override
            public void act(TotemBaseBlockEntity totemBaseBlockEntity, Bee bee) {
                Bee.BeePollinateGoal goal = bee.f_27699_;
                if (goal.m_7989_()) {
                    goal.f_28064_ += 40;
                    goal.m_8037_();
                    ParticleEffectTypeRegistry.HEXING_SMOKE.createEntityEffect((Entity)bee, new ColorEffectData(SpiritTypeRegistry.SACRED_SPIRIT.getPrimaryColor()));
                }
            }
        });
        m.put(Chicken.class, new NourishmentRiteActor<Chicken>(Chicken.class){

            @Override
            public void act(TotemBaseBlockEntity totemBaseBlockEntity, Chicken chicken) {
                chicken.f_28231_ -= 80;
                ParticleEffectTypeRegistry.HEXING_SMOKE.createEntityEffect((Entity)chicken, new ColorEffectData(SpiritTypeRegistry.SACRED_SPIRIT.getPrimaryColor()));
            }
        });
        m.put(Allay.class, new NourishmentRiteActor<Allay>(Allay.class){

            @Override
            public void act(TotemBaseBlockEntity totemBaseBlockEntity, Allay allay) {
                allay.f_238791_ -= 80L;
                ParticleEffectTypeRegistry.HEXING_SMOKE.createEntityEffect((Entity)allay, new ColorEffectData(SpiritTypeRegistry.SACRED_SPIRIT.getPrimaryColor()));
            }
        });
    });

    public SacredRiteType() {
        super("sacred_rite", SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.SACRED_SPIRIT, SpiritTypeRegistry.SACRED_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, LivingEntity.class, e -> !(e instanceof Monster)).forEach(e -> {
                    if (e.m_21223_() < e.m_21233_()) {
                        e.m_5634_(2.0f);
                        ParticleEffectTypeRegistry.HEXING_SMOKE.createEntityEffect((Entity)e, new ColorEffectData(SpiritTypeRegistry.SACRED_SPIRIT.getPrimaryColor()));
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, Mob.class).forEach(e -> {
                    Animal animal;
                    if (e instanceof Animal && (animal = (Animal)e).m_146764_() < 0 && totemBase.m_58904_().f_46441_.m_188501_() <= 0.04f) {
                        ParticleEffectTypeRegistry.HEXING_SMOKE.createEntityEffect((Entity)e, new ColorEffectData(SpiritTypeRegistry.SACRED_SPIRIT.getPrimaryColor()));
                        animal.m_146758_(25);
                    }
                    if (NOURISHMENT_RITE_ACTORS.containsKey(e.getClass())) {
                        NourishmentRiteActor<?> nourishmentRiteActor = NOURISHMENT_RITE_ACTORS.get(e.getClass());
                        nourishmentRiteActor.tryAct(totemBase, (Mob)e);
                    }
                });
            }
        };
    }

    public static abstract class NourishmentRiteActor<T extends Mob> {
        public final Class<T> targetClass;

        public NourishmentRiteActor(Class<T> targetClass) {
            this.targetClass = targetClass;
        }

        public final void tryAct(TotemBaseBlockEntity totemBaseBlockEntity, Mob mob) {
            if (this.targetClass.isInstance(mob)) {
                this.act(totemBaseBlockEntity, mob);
            }
        }

        public abstract void act(TotemBaseBlockEntity var1, T var2);
    }
}

