/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei.categories;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.compability.jei.JEIHandler;
import com.sammy.malum.registry.common.item.ItemRegistry;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SpiritRiteRecipeCategory
implements IRecipeCategory<TotemicRiteType> {
    public static final ResourceLocation UID = MalumMod.malumPath("spirit_rite");
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final Font font;

    public SpiritRiteRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 185);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("malum", "textures/gui/spirit_rite_jei.png"), 0, 0, 142, 183);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemRegistry.RUNEWOOD_TOTEM_BASE.get()));
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public void draw(TotemicRiteType rite, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.overlay.draw(guiGraphics);
        String translated = I18n.m_118938_((String)rite.translationIdentifier(false), (Object[])new Object[0]);
        ArcanaCodexHelper.renderText(guiGraphics, (Component)Component.m_237113_((String)translated), 71 - this.font.m_92895_(translated) / 2, 160);
    }

    public RecipeType<TotemicRiteType> getRecipeType() {
        return JEIHandler.RITES;
    }

    public Component getTitle() {
        return Component.m_237115_((String)("malum.jei." + UID.m_135815_()));
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TotemicRiteType rite, IFocusGroup focuses) {
        for (int i = 0; i < rite.spirits.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 63, 121 - 20 * i).addItemStack(rite.spirits.get((int)i).spiritShard.get().m_7968_());
        }
    }
}

